/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.exceptions.BuildNotFoundException;
import net.nemerosa.ontrack.model.exceptions.ValidationStampNotFoundException;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.StandardBuildFilterData;
import net.nemerosa.ontrack.repository.CoreBuildFilterRepository;
import net.nemerosa.ontrack.repository.StructureRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CoreBuildFilterJdbcRepository
extends AbstractJdbcRepository
implements CoreBuildFilterRepository {
    private final StructureRepository structureRepository;

    @Autowired
    public CoreBuildFilterJdbcRepository(DataSource dataSource, StructureRepository structureRepository) {
        super(dataSource);
        this.structureRepository = structureRepository;
    }

    public List<Build> standardFilter(Branch branch, StandardBuildFilterData data) {
        String linkedTo;
        String linkedFrom;
        String sincePropertyValue;
        Integer id;
        String sinceProperty;
        String withProperty;
        String withValidationStamp;
        int validationStampId;
        Integer id2;
        String sinceValidationStamp;
        LocalDate beforeDate;
        LocalDate afterDate;
        String withPromotionLevel;
        int promotionLevelId;
        Integer id3;
        StringBuilder tables = new StringBuilder("SELECT DISTINCT(B.ID) FROM BUILDS B ");
        StringBuilder criteria = new StringBuilder(" WHERE B.BRANCHID = :branch");
        MapSqlParameterSource params = new MapSqlParameterSource("branch", (Object)branch.id());
        Integer sinceBuildId = null;
        String sincePromotionLevel = data.getSincePromotionLevel();
        if (StringUtils.isNotBlank((CharSequence)sincePromotionLevel) && (id3 = this.findLastBuildWithPromotionLevel(promotionLevelId = this.structureRepository.getPromotionLevelByName(branch, sincePromotionLevel).map(Entity::id).orElse(-1).intValue())) != null) {
            sinceBuildId = id3;
        }
        if (StringUtils.isNotBlank((CharSequence)(withPromotionLevel = data.getWithPromotionLevel()))) {
            tables.append(" LEFT JOIN PROMOTION_RUNS PR ON PR.BUILDID = B.ID LEFT JOIN PROMOTION_LEVELS PL ON PL.ID = PR.PROMOTIONLEVELID");
            criteria.append(" AND PL.NAME = :withPromotionLevel");
            params.addValue("withPromotionLevel", (Object)withPromotionLevel);
        }
        if ((afterDate = data.getAfterDate()) != null) {
            criteria.append(" AND B.CREATION >= :afterDate");
            params.addValue("afterDate", (Object)CoreBuildFilterJdbcRepository.dateTimeForDB((LocalDateTime)afterDate.atTime(0, 0)));
        }
        if ((beforeDate = data.getBeforeDate()) != null) {
            criteria.append(" AND B.CREATION <= :beforeDate");
            params.addValue("beforeDate", (Object)CoreBuildFilterJdbcRepository.dateTimeForDB((LocalDateTime)beforeDate.atTime(23, 59, 59)));
        }
        if (StringUtils.isNotBlank((CharSequence)(sinceValidationStamp = data.getSinceValidationStamp())) && (id2 = this.findLastBuildWithValidationStamp(validationStampId = this.getValidationStampId(branch, sinceValidationStamp).intValue(), data.getSinceValidationStampStatus())) != null) {
            sinceBuildId = sinceBuildId == null ? id2 : Integer.valueOf(Math.max(sinceBuildId, id2));
        }
        if (StringUtils.isNotBlank((CharSequence)(withValidationStamp = data.getWithValidationStamp()))) {
            tables.append("  LEFT JOIN ( SELECT R.BUILDID,  R.VALIDATIONSTAMPID, VRS.VALIDATIONRUNSTATUSID  FROM VALIDATION_RUNS R INNER JOIN VALIDATION_RUN_STATUSES VRS ON VRS.ID = (SELECT ID FROM VALIDATION_RUN_STATUSES WHERE VALIDATIONRUNID = R.ID ORDER BY ID DESC LIMIT 1) AND R.ID = (SELECT MAX(ID) FROM VALIDATION_RUNS WHERE BUILDID = R.BUILDID AND VALIDATIONSTAMPID = R.VALIDATIONSTAMPID) ) S ON S.BUILDID = B.ID");
            int validationStampId2 = this.getValidationStampId(branch, withValidationStamp);
            criteria.append(" AND (S.VALIDATIONSTAMPID = :validationStampId");
            params.addValue("validationStampId", (Object)validationStampId2);
            String withValidationStampStatus = data.getWithValidationStampStatus();
            if (StringUtils.isNotBlank((CharSequence)withValidationStampStatus)) {
                criteria.append(" AND S.VALIDATIONRUNSTATUSID = :withValidationStampStatus");
                params.addValue("withValidationStampStatus", (Object)withValidationStampStatus);
            }
            criteria.append(")");
        }
        if (StringUtils.isNotBlank((CharSequence)(withProperty = data.getWithProperty()))) {
            tables.append(" LEFT JOIN PROPERTIES PP ON PP.BUILD = B.ID");
            criteria.append(" AND PP.TYPE = :withProperty");
            params.addValue("withProperty", (Object)withProperty);
            String withPropertyValue = data.getWithPropertyValue();
            if (StringUtils.isNotBlank((CharSequence)withPropertyValue)) {
                criteria.append(" AND PP.SEARCHKEY REGEXP :withPropertyValue");
                params.addValue("withPropertyValue", (Object)withPropertyValue);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(sinceProperty = data.getSinceProperty())) && (id = this.findLastBuildWithPropertyValue(branch, sinceProperty, sincePropertyValue = data.getSincePropertyValue())) != null) {
            sinceBuildId = sinceBuildId == null ? id : Integer.valueOf(Math.max(sinceBuildId, id));
        }
        if (StringUtils.isNotBlank((CharSequence)(linkedFrom = data.getLinkedFrom()))) {
            String linkedFromPromotion;
            tables.append(" LEFT JOIN BUILD_LINKS BLFROM ON BLFROM.TARGETBUILDID = B.ID LEFT JOIN BUILDS BDFROM ON BDFROM.ID = BLFROM.BUILDID LEFT JOIN BRANCHES BRFROM ON BRFROM.ID = BDFROM.BRANCHID LEFT JOIN PROJECTS PJFROM ON PJFROM.ID = BRFROM.PROJECTID");
            String project = StringUtils.substringBefore((String)linkedFrom, (String)":");
            criteria.append(" AND PJFROM.NAME = :fromProject");
            params.addValue("fromProject", (Object)project);
            String buildPattern = StringUtils.substringAfter((String)linkedFrom, (String)":");
            if (StringUtils.isNotBlank((CharSequence)buildPattern)) {
                if (StringUtils.contains((CharSequence)buildPattern, (CharSequence)"*")) {
                    criteria.append(" AND BDFROM.NAME LIKE :buildFrom");
                    params.addValue("buildFrom", (Object)StringUtils.replace((String)buildPattern, (String)"*", (String)"%"));
                } else {
                    criteria.append(" AND BDFROM.NAME = :buildFrom");
                    params.addValue("buildFrom", (Object)buildPattern);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(linkedFromPromotion = data.getLinkedFromPromotion()))) {
                tables.append(" LEFT JOIN PROMOTION_RUNS PRFROM ON PRFROM.BUILDID = BDFROM.ID LEFT JOIN PROMOTION_LEVELS PLFROM ON PLFROM.ID = PRFROM.PROMOTIONLEVELID");
                criteria.append(" AND PLFROM.NAME = :linkedFromPromotion");
                params.addValue("linkedFromPromotion", (Object)linkedFromPromotion);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(linkedTo = data.getLinkedTo()))) {
            String linkedToPromotion;
            tables.append(" LEFT JOIN BUILD_LINKS BLTO ON BLTO.BUILDID = B.ID LEFT JOIN BUILDS BDTO ON BDTO.ID = BLTO.TARGETBUILDID LEFT JOIN BRANCHES BRTO ON BRTO.ID = BDTO.BRANCHID LEFT JOIN PROJECTS PJTO ON PJTO.ID = BRTO.PROJECTID");
            String project = StringUtils.substringBefore((String)linkedTo, (String)":");
            criteria.append(" AND PJTO.NAME = :toProject");
            params.addValue("toProject", (Object)project);
            String buildPattern = StringUtils.substringAfter((String)linkedTo, (String)":");
            if (StringUtils.isNotBlank((CharSequence)buildPattern)) {
                if (StringUtils.contains((CharSequence)buildPattern, (CharSequence)"*")) {
                    criteria.append(" AND BDTO.NAME LIKE :buildTo");
                    params.addValue("buildTo", (Object)StringUtils.replace((String)buildPattern, (String)"*", (String)"%"));
                } else {
                    criteria.append(" AND BDTO.NAME = :buildTo");
                    params.addValue("buildTo", (Object)buildPattern);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(linkedToPromotion = data.getLinkedToPromotion()))) {
                tables.append(" LEFT JOIN PROMOTION_RUNS PRTO ON PRTO.BUILDID = BDTO.ID LEFT JOIN PROMOTION_LEVELS PLTO ON PLTO.ID = PRTO.PROMOTIONLEVELID");
                criteria.append(" AND PLTO.NAME = :linkedToPromotion");
                params.addValue("linkedToPromotion", (Object)linkedToPromotion);
            }
        }
        if (sinceBuildId != null) {
            criteria.append(" AND B.ID >= :sinceBuildId");
            params.addValue("sinceBuildId", (Object)sinceBuildId);
        }
        String sql = String.format("%s %s ORDER BY B.ID DESC LIMIT :count", tables, criteria);
        params.addValue("count", (Object)data.getCount());
        return this.loadBuilds(sql, params);
    }

    private List<Build> loadBuilds(String sql, MapSqlParameterSource params) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, (SqlParameterSource)params, Integer.class).stream().map(id -> this.structureRepository.getBuild(ID.of((int)id))).collect(Collectors.toList());
    }

    public List<Build> nameFilter(Branch branch, String fromBuild, String toBuild, String withPromotionLevel, int count) {
        Optional<Integer> toBuildId;
        StringBuilder sql = new StringBuilder("SELECT DISTINCT(B.ID) FROM BUILDS B                LEFT JOIN PROMOTION_RUNS PR ON PR.BUILDID = B.ID                LEFT JOIN PROMOTION_LEVELS PL ON PL.ID = PR.PROMOTIONLEVELID                WHERE B.BRANCHID = :branch");
        MapSqlParameterSource params = new MapSqlParameterSource("branch", (Object)branch.id());
        Optional<Integer> fromBuildId = this.lastBuild(branch, fromBuild, null).map(Entity::id);
        if (!fromBuildId.isPresent()) {
            return Collections.emptyList();
        }
        sql.append(" AND B.ID >= :fromBuildId");
        params.addValue("fromBuildId", (Object)fromBuildId.get());
        if (StringUtils.isNotBlank((CharSequence)toBuild) && (toBuildId = this.lastBuild(branch, toBuild, null).map(Entity::id)).isPresent()) {
            sql.append(" AND B.ID <= :toBuildId");
            params.addValue("toBuildId", (Object)toBuildId.get());
        }
        if (StringUtils.isNotBlank((CharSequence)withPromotionLevel)) {
            sql.append(" AND PL.NAME = :withPromotionLevel");
            params.addValue("withPromotionLevel", (Object)withPromotionLevel);
        }
        sql.append(" ORDER BY B.ID DESC");
        sql.append(" LIMIT :count");
        params.addValue("count", (Object)count);
        return this.loadBuilds(sql.toString(), params);
    }

    public Optional<Build> lastBuild(Branch branch, String sinceBuild, String withPromotionLevel) {
        StringBuilder sql = new StringBuilder("SELECT DISTINCT(B.ID) FROM BUILDS B                LEFT JOIN PROMOTION_RUNS PR ON PR.BUILDID = B.ID                LEFT JOIN PROMOTION_LEVELS PL ON PL.ID = PR.PROMOTIONLEVELID                WHERE B.BRANCHID = :branch");
        MapSqlParameterSource params = new MapSqlParameterSource("branch", (Object)branch.id());
        if (StringUtils.contains((CharSequence)sinceBuild, (CharSequence)"*")) {
            sql.append(" AND B.NAME LIKE :buildName");
            params.addValue("buildName", (Object)StringUtils.replace((String)sinceBuild, (String)"*", (String)"%"));
        } else {
            sql.append(" AND B.NAME = :buildName");
            params.addValue("buildName", (Object)sinceBuild);
        }
        if (StringUtils.isNotBlank((CharSequence)withPromotionLevel)) {
            sql.append(" AND PL.NAME = :withPromotionLevel");
            params.addValue("withPromotionLevel", (Object)withPromotionLevel);
        }
        sql.append(" ORDER BY B.ID DESC");
        sql.append(" LIMIT 1");
        return this.loadBuilds(sql.toString(), params).stream().findFirst();
    }

    public List<Build> between(Branch branch, String from, String to) {
        StringBuilder sql = new StringBuilder("SELECT ID FROM BUILDS WHERE BRANCHID = :branchId ");
        MapSqlParameterSource params = this.params("branchId", branch.id());
        Integer toId = null;
        Integer fromId = ((Build)this.structureRepository.getBuildByName(branch.getProject().getName(), branch.getName(), from).orElseThrow(() -> new BuildNotFoundException(branch.getProject().getName(), branch.getName(), from))).id();
        if (StringUtils.isNotBlank((CharSequence)to)) {
            toId = ((Build)this.structureRepository.getBuildByName(branch.getProject().getName(), branch.getName(), to).orElseThrow(() -> new BuildNotFoundException(branch.getProject().getName(), branch.getName(), to))).id();
        }
        if (toId != null && toId < fromId) {
            int i = toId;
            toId = fromId;
            fromId = i;
        }
        sql.append(" AND ID >= :fromId");
        params.addValue("fromId", (Object)fromId);
        if (toId != null) {
            sql.append(" AND ID <= :toId");
            params.addValue("toId", (Object)toId);
        }
        sql.append(" ORDER BY ID DESC");
        return this.loadBuilds(sql.toString(), params);
    }

    private Integer findLastBuildWithPropertyValue(Branch branch, String propertyType, String propertyValue) {
        StringBuilder sql = new StringBuilder("SELECT B.ID FROM BUILDS B LEFT JOIN PROPERTIES PP ON PP.BUILD = B.ID WHERE B.BRANCHID = :branchId AND PP.TYPE = :propertyType ");
        MapSqlParameterSource params = this.params("branchId", branch.id()).addValue("propertyType", (Object)propertyType);
        if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
            sql.append(" AND PP.SEARCHKEY REGEXP :propertyValue");
            params.addValue("propertyValue", (Object)propertyValue);
        }
        sql.append(" ORDER BY B.ID DESC LIMIT 1");
        return (Integer)this.getFirstItem(sql.toString(), params, Integer.class);
    }

    private Integer getValidationStampId(Branch branch, String validationStampName) {
        return this.structureRepository.getValidationStampByName(branch, validationStampName).map(Entity::id).orElseThrow(() -> new ValidationStampNotFoundException(branch.getProject().getName(), branch.getName(), validationStampName));
    }

    private Integer findLastBuildWithValidationStamp(int validationStampId, String status) {
        StringBuilder sql = new StringBuilder("SELECT VR.BUILDID FROM VALIDATION_RUN_STATUSES VRS\nINNER JOIN VALIDATION_RUNS VR ON VR.ID = VRS.VALIDATIONRUNID\nWHERE VR.VALIDATIONSTAMPID = :validationStampId\n");
        MapSqlParameterSource params = this.params("validationStampId", validationStampId);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            sql.append("AND VRS.VALIDATIONRUNSTATUSID = :status\n");
            params.addValue("status", (Object)status);
        }
        sql.append("ORDER BY VR.BUILDID DESC LIMIT 1\n");
        return (Integer)this.getFirstItem(sql.toString(), params, Integer.class);
    }

    private Integer findLastBuildWithPromotionLevel(int promotionLevelId) {
        return (Integer)this.getFirstItem("SELECT BUILDID FROM PROMOTION_RUNS WHERE PROMOTIONLEVELID = :promotionLevelId ORDER BY BUILDID DESC LIMIT 1", this.params("promotionLevelId", promotionLevelId), Integer.class);
    }
}

