/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.ConfigurationRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConfigurationJdbcRepository
extends AbstractJdbcRepository
implements ConfigurationRepository {
    @Autowired
    public ConfigurationJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public <T extends Configuration<T>> List<T> list(Class<T> configurationClass) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM CONFIGURATIONS WHERE TYPE = :type ORDER BY NAME", (SqlParameterSource)this.params("type", configurationClass.getName()), (rs, rowNum) -> (Configuration)this.readJson(configurationClass, rs, "content"));
    }

    public <T extends Configuration<T>> Optional<T> find(Class<T> configurationClass, String name) {
        return Optional.ofNullable(this.getFirstItem("SELECT * FROM CONFIGURATIONS WHERE TYPE = :type AND NAME = :name", this.params("type", configurationClass.getName()).addValue("name", (Object)name), (rs, rowNum) -> (Configuration)this.readJson(configurationClass, rs, "content")));
    }

    public <T extends Configuration<T>> T save(T configuration) {
        MapSqlParameterSource params = this.params("type", configuration.getClass().getName()).addValue("name", (Object)configuration.getName());
        Integer id = (Integer)this.getFirstItem("SELECT ID FROM CONFIGURATIONS WHERE TYPE = :type AND NAME = :name", params, Integer.class);
        if (id != null) {
            this.getNamedParameterJdbcTemplate().update("UPDATE CONFIGURATIONS SET CONTENT = :content WHERE ID = :id", (SqlParameterSource)params.addValue("content", (Object)this.writeJson(configuration)).addValue("id", (Object)id));
        } else {
            this.getNamedParameterJdbcTemplate().update("INSERT INTO CONFIGURATIONS(TYPE, NAME, CONTENT) VALUES (:type, :name, :content)", (SqlParameterSource)params.addValue("content", (Object)this.writeJson(configuration)));
        }
        return configuration;
    }

    public <T extends Configuration<T>> void delete(Class<T> configurationClass, String name) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM CONFIGURATIONS WHERE TYPE = :type AND NAME = :name", (SqlParameterSource)this.params("type", configurationClass.getName()).addValue("name", (Object)name));
    }
}

