/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.repository.BuildFilterRepository;
import net.nemerosa.ontrack.repository.TBuildFilter;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BuildFilterJdbcRepository
extends AbstractJdbcRepository
implements BuildFilterRepository {
    @Autowired
    public BuildFilterJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public Collection<TBuildFilter> findForBranch(int branchId) {
        return this.order(this.getNamedParameterJdbcTemplate().query("(SELECT * FROM BUILD_FILTERS WHERE BRANCHID = :branchId) UNION (SELECT NULL AS accountId, * FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId)", (SqlParameterSource)this.params("branchId", branchId), (rs, row) -> this.toBuildFilter(rs)));
    }

    public Collection<TBuildFilter> findForBranch(OptionalInt accountId, int branchId) {
        if (accountId.isPresent()) {
            return this.order(this.getNamedParameterJdbcTemplate().query("(SELECT * FROM BUILD_FILTERS WHERE ACCOUNTID = :accountId AND BRANCHID = :branchId) UNION (SELECT NULL AS accountId, * FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId)", (SqlParameterSource)this.params("branchId", branchId).addValue("accountId", (Object)accountId.getAsInt()), (rs, row) -> this.toBuildFilter(rs)));
        }
        return this.getNamedParameterJdbcTemplate().query("SELECT NULL AS accountId, * FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId ORDER BY NAME", (SqlParameterSource)this.params("branchId", branchId), (rs, row) -> this.toBuildFilter(rs));
    }

    protected List<TBuildFilter> order(List<TBuildFilter> filters) {
        ArrayList<TBuildFilter> ordered = new ArrayList<TBuildFilter>(filters);
        Collections.sort(ordered, (o1, o2) -> {
            OptionalInt a1 = o1.getAccountId();
            OptionalInt a2 = o2.getAccountId();
            if (a1.isPresent() == a2.isPresent()) {
                return o1.getName().compareTo(o2.getName());
            }
            if (a1.isPresent()) {
                return 1;
            }
            return -1;
        });
        return ordered;
    }

    public Optional<TBuildFilter> findByBranchAndName(int accountId, int branchId, String name) {
        MapSqlParameterSource params = this.params("branchId", branchId).addValue("accountId", (Object)accountId).addValue("name", (Object)name);
        Optional shared = this.getOptional("SELECT NULL AS accountId, * FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId AND NAME = :name", params, (rs, row) -> this.toBuildFilter(rs));
        if (shared.isPresent()) {
            return shared;
        }
        return this.getOptional("SELECT * FROM BUILD_FILTERS WHERE ACCOUNTID = :accountId AND BRANCHID = :branchId AND NAME = :name", params, (rs, row) -> this.toBuildFilter(rs));
    }

    public Ack save(OptionalInt accountId, int branchId, String name, String type, JsonNode data) {
        if (accountId.isPresent()) {
            MapSqlParameterSource params = this.params("branchId", branchId).addValue("accountId", (Object)accountId.getAsInt()).addValue("name", (Object)name);
            this.getNamedParameterJdbcTemplate().update("DELETE FROM BUILD_FILTERS WHERE ACCOUNTID = :accountId AND BRANCHID = :branchId AND NAME = :name", (SqlParameterSource)params);
            return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO BUILD_FILTERS (ACCOUNTID, BRANCHID, NAME, TYPE, DATA) VALUES (:accountId, :branchId, :name, :type, :data)", (SqlParameterSource)params.addValue("type", (Object)type).addValue("data", (Object)this.writeJson(data))));
        }
        MapSqlParameterSource params = this.params("branchId", branchId).addValue("name", (Object)name);
        this.getNamedParameterJdbcTemplate().update("DELETE FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId AND NAME = :name", (SqlParameterSource)params);
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("INSERT INTO SHARED_BUILD_FILTERS (BRANCHID, NAME, TYPE, DATA) VALUES (:branchId, :name, :type, :data)", (SqlParameterSource)params.addValue("type", (Object)type).addValue("data", (Object)this.writeJson(data))));
    }

    public Ack delete(int accountId, int branchId, String name, boolean shared) {
        Ack accountFilterDeleted = Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM BUILD_FILTERS WHERE ACCOUNTID = :accountId AND BRANCHID = :branchId AND NAME = :name", (SqlParameterSource)this.params("branchId", branchId).addValue("accountId", (Object)accountId).addValue("name", (Object)name)));
        if (shared) {
            return accountFilterDeleted.or(Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM SHARED_BUILD_FILTERS WHERE BRANCHID = :branchId AND NAME = :name", (SqlParameterSource)this.params("branchId", branchId).addValue("name", (Object)name))));
        }
        return accountFilterDeleted;
    }

    private TBuildFilter toBuildFilter(ResultSet rs) throws SQLException {
        return new TBuildFilter(this.optionalInt(rs, "accountId"), rs.getInt("branchId"), rs.getString("name"), rs.getString("type"), this.readJson(rs, "data"));
    }
}

