/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.structure.BranchTemplateDefinition;
import net.nemerosa.ontrack.model.structure.BranchTemplateInstance;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.structure.TemplateDefinition;
import net.nemerosa.ontrack.model.structure.TemplateInstance;
import net.nemerosa.ontrack.model.structure.TemplateParameter;
import net.nemerosa.ontrack.model.structure.TemplateParameterValue;
import net.nemerosa.ontrack.model.structure.TemplateSynchronisationAbsencePolicy;
import net.nemerosa.ontrack.repository.BranchTemplateRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BranchTemplateJdbcRepository
extends AbstractJdbcRepository
implements BranchTemplateRepository {
    @Autowired
    public BranchTemplateJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public Collection<BranchTemplateDefinition> getTemplateDefinitions() {
        return this.getJdbcTemplate().query("SELECT * FROM BRANCH_TEMPLATE_DEFINITIONS", (rs, num) -> new BranchTemplateDefinition(this.id(rs, "BRANCHID"), this.toTemplateDefinition(rs)));
    }

    public Optional<TemplateDefinition> getTemplateDefinition(ID branchId) {
        return this.getOptional("SELECT * FROM BRANCH_TEMPLATE_DEFINITIONS WHERE BRANCHID = :branchId", this.params("branchId", branchId.get()), (rs, num) -> this.toTemplateDefinition(rs));
    }

    private TemplateDefinition toTemplateDefinition(ResultSet rs) throws SQLException {
        int branchId = rs.getInt("branchId");
        List parameters = this.getNamedParameterJdbcTemplate().query("SELECT * FROM BRANCH_TEMPLATE_DEFINITION_PARAMS WHERE BRANCHID = :branchId ORDER BY NAME", (SqlParameterSource)this.params("branchId", branchId), (rsp, num) -> new TemplateParameter(rsp.getString("NAME"), rsp.getString("DESCRIPTION"), rsp.getString("EXPRESSION")));
        return new TemplateDefinition(parameters, new ServiceConfiguration(rs.getString("SYNCHRONISATIONSOURCEID"), this.readJson(rs, "SYNCHRONISATIONSOURCECONFIG")), (TemplateSynchronisationAbsencePolicy)this.getEnum(TemplateSynchronisationAbsencePolicy.class, rs, "ABSENCEPOLICY"), rs.getInt("SYNCINTERVAL"));
    }

    public void setTemplateDefinition(ID branchId, TemplateDefinition templateDefinition) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM BRANCH_TEMPLATE_DEFINITIONS WHERE BRANCHID = :branchId", (SqlParameterSource)this.params("branchId", branchId.get()));
        this.getNamedParameterJdbcTemplate().update("INSERT INTO BRANCH_TEMPLATE_DEFINITIONS(BRANCHID, ABSENCEPOLICY, SYNCINTERVAL, SYNCHRONISATIONSOURCEID, SYNCHRONISATIONSOURCECONFIG) VALUES (:branchId, :absencePolicy, :interval, :synchronisationSourceId, :synchronisationSourceConfig)", (SqlParameterSource)this.params("branchId", branchId.get()).addValue("absencePolicy", (Object)templateDefinition.getAbsencePolicy().name()).addValue("interval", (Object)templateDefinition.getInterval()).addValue("synchronisationSourceId", (Object)templateDefinition.getSynchronisationSourceConfig().getId()).addValue("synchronisationSourceConfig", (Object)this.writeJson(templateDefinition.getSynchronisationSourceConfig().getData())));
        for (TemplateParameter parameter : templateDefinition.getParameters()) {
            this.getNamedParameterJdbcTemplate().update("INSERT INTO BRANCH_TEMPLATE_DEFINITION_PARAMS(BRANCHID, NAME, DESCRIPTION, EXPRESSION) VALUES (:branchId, :name, :description, :expression)", (SqlParameterSource)this.params("branchId", branchId.get()).addValue("name", (Object)parameter.getName()).addValue("description", (Object)parameter.getDescription()).addValue("expression", (Object)parameter.getExpression()));
        }
    }

    public boolean isTemplateDefinition(ID branchId) {
        return this.getFirstItem("SELECT BRANCHID FROM BRANCH_TEMPLATE_DEFINITIONS WHERE BRANCHID = :branchId", this.params("branchId", branchId.get()), Integer.class) != null;
    }

    public Optional<TemplateInstance> getTemplateInstance(ID branchId) {
        return this.getOptional("SELECT * FROM BRANCH_TEMPLATE_INSTANCES WHERE BRANCHID = :branchId", this.params("branchId", branchId.get()), (rs, num) -> this.toTemplateInstance(rs));
    }

    private TemplateInstance toTemplateInstance(ResultSet rs) throws SQLException {
        int branchId = rs.getInt("branchId");
        List parameters = this.getNamedParameterJdbcTemplate().query("SELECT * FROM BRANCH_TEMPLATE_INSTANCE_PARAMS WHERE BRANCHID = :branchId ORDER BY NAME", (SqlParameterSource)this.params("branchId", branchId), (rsp, num) -> new TemplateParameterValue(rsp.getString("NAME"), rsp.getString("VALUE")));
        return new TemplateInstance(this.id(rs, "TEMPLATEBRANCHID"), parameters);
    }

    public Collection<BranchTemplateInstance> getTemplateInstancesForDefinition(ID templateDefinitionId) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM BRANCH_TEMPLATE_INSTANCES WHERE TEMPLATEBRANCHID = :templateDefinitionId", (SqlParameterSource)this.params("templateDefinitionId", templateDefinitionId.get()), (rs, num) -> new BranchTemplateInstance(this.id(rs, "BRANCHID"), this.toTemplateInstance(rs)));
    }

    public void disconnectTemplateInstance(ID branchId) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM BRANCH_TEMPLATE_INSTANCES WHERE BRANCHID = :branchId", (SqlParameterSource)this.params("branchId", branchId.get()));
    }

    public void setTemplateInstance(ID branchId, TemplateInstance templateInstance) {
        this.disconnectTemplateInstance(branchId);
        this.getNamedParameterJdbcTemplate().update("INSERT INTO BRANCH_TEMPLATE_INSTANCES(BRANCHID, TEMPLATEBRANCHID) VALUES (:branchId, :templateBranchId)", (SqlParameterSource)this.params("branchId", branchId.get()).addValue("templateBranchId", (Object)templateInstance.getTemplateDefinitionId().get()));
        for (TemplateParameterValue parameter : templateInstance.getParameterValues()) {
            this.getNamedParameterJdbcTemplate().update("INSERT INTO BRANCH_TEMPLATE_INSTANCE_PARAMS(BRANCHID, NAME, VALUE) VALUES (:branchId, :name, :value)", (SqlParameterSource)this.params("branchId", branchId.get()).addValue("name", (Object)parameter.getName()).addValue("value", (Object)parameter.getValue()));
        }
    }

    public boolean isTemplateInstance(ID branchId) {
        return this.getFirstItem("SELECT BRANCHID FROM BRANCH_TEMPLATE_INSTANCES WHERE BRANCHID = :branchId", this.params("branchId", branchId.get()), Integer.class) != null;
    }
}

