/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.exceptions.JsonParsingException;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntry;
import net.nemerosa.ontrack.model.support.ApplicationLogEntryFilter;
import net.nemerosa.ontrack.model.support.ApplicationLogEntryLevel;
import net.nemerosa.ontrack.model.support.Page;
import net.nemerosa.ontrack.repository.ApplicationLogEntriesRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ApplicationLogEntriesJdbcRepository
extends AbstractJdbcRepository
implements ApplicationLogEntriesRepository {
    @Autowired
    public ApplicationLogEntriesJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public void log(ApplicationLogEntry entry) {
        this.getNamedParameterJdbcTemplate().update("INSERT INTO APPLICATION_LOG_ENTRIES(LEVEL, TIMESTAMP, AUTHENTICATION,NAME, DESCRIPTION, INFORMATION, EXCEPTION, DETAILS) VALUES (:level, :timestamp, :authentication, :name, :description, :information, :exception, :details)", (SqlParameterSource)this.params("level", entry.getLevel().name()).addValue("timestamp", (Object)ApplicationLogEntriesJdbcRepository.dateTimeForDB((LocalDateTime)entry.getTimestamp())).addValue("authentication", (Object)entry.getAuthentication()).addValue("name", (Object)entry.getType().getName()).addValue("description", (Object)entry.getType().getDescription()).addValue("information", (Object)entry.getInformation()).addValue("exception", (Object)entry.getStacktrace()).addValue("details", (Object)this.getDetailsAsJson(entry.getDetails())));
    }

    public int getTotalCount() {
        return (Integer)this.getFirstItem("SELECT COUNT(*) FROM APPLICATION_LOG_ENTRIES", this.noParams(), Integer.class);
    }

    public List<ApplicationLogEntry> getLogEntries(ApplicationLogEntryFilter filter, Page page) {
        int total = this.getTotalCount();
        int offset = page.getOffset();
        if (offset >= total) {
            return Collections.emptyList();
        }
        MapSqlParameterSource params = this.noParams();
        StringBuilder query = new StringBuilder("SELECT * FROM APPLICATION_LOG_ENTRIES WHERE 1 = 1 ");
        if (filter.getLevel() != null) {
            query.append(" AND LEVEL = :level");
            params = params.addValue("level", (Object)filter.getLevel().name());
        }
        if (filter.getBefore() != null) {
            query.append(" AND TIMESTAMP <= :before");
            params = params.addValue("before", (Object)ApplicationLogEntriesJdbcRepository.dateTimeForDB((LocalDateTime)filter.getBefore()));
        }
        if (filter.getAfter() != null) {
            query.append(" AND TIMESTAMP >= :after");
            params = params.addValue("after", (Object)ApplicationLogEntriesJdbcRepository.dateTimeForDB((LocalDateTime)filter.getAfter()));
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getAuthentication())) {
            query.append(" AND AUTHENTICATION = :authentication");
            params = params.addValue("authentication", (Object)filter.getAuthentication());
        }
        if (StringUtils.isNotBlank((CharSequence)filter.getText())) {
            query.append(" AND (NAME LIKE :text OR DESCRIPTION LIKE :text OR INFORMATION LIKE :text OR DETAILS LIKE :text)");
            params = params.addValue("text", (Object)("%" + filter.getText() + "%"));
        }
        query.append(" ORDER BY ID DESC");
        query.append(" LIMIT :page OFFSET :offset");
        params = params.addValue("page", (Object)page.getCount()).addValue("offset", (Object)page.getOffset());
        List entries = this.getNamedParameterJdbcTemplate().query(query.toString(), (SqlParameterSource)params, (rs, rowNum) -> new ApplicationLogEntry((ApplicationLogEntryLevel)this.getEnum(ApplicationLogEntryLevel.class, rs, "LEVEL"), ApplicationLogEntriesJdbcRepository.dateTimeFromDB((String)rs.getString("TIMESTAMP")), rs.getString("AUTHENTICATION"), NameDescription.nd((String)rs.getString("NAME"), (String)rs.getString("DESCRIPTION")), rs.getString("INFORMATION"), rs.getString("EXCEPTION"), this.getDetailsFromJson(rs)));
        return entries;
    }

    public void cleanup(int retentionDays) {
        LocalDateTime pivotDate = Time.now().minus(retentionDays, ChronoUnit.DAYS);
        this.getNamedParameterJdbcTemplate().update("DELETE FROM APPLICATION_LOG_ENTRIES WHERE TIMESTAMP < :date", (SqlParameterSource)this.params("date", ApplicationLogEntriesJdbcRepository.dateTimeForDB((LocalDateTime)pivotDate)));
    }

    public void deleteLogEntries() {
        this.getJdbcTemplate().update("DELETE FROM APPLICATION_LOG_ENTRIES");
    }

    private Map<String, String> getDetailsFromJson(ResultSet rs) throws SQLException {
        try {
            return JsonUtils.toMap((JsonNode)this.readJson(rs, "DETAILS"));
        }
        catch (IOException e) {
            throw new JsonParsingException((Exception)e);
        }
    }

    private String getDetailsAsJson(Map<String, String> details) {
        return details != null ? this.writeJson(details) : "{}";
    }
}

