/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.AccountNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AuthenticationSource;
import net.nemerosa.ontrack.model.security.AuthenticationSourceProvider;
import net.nemerosa.ontrack.model.security.SecurityRole;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.repository.AccountRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AccountJdbcRepository
extends AbstractJdbcRepository
implements AccountRepository {
    @Autowired
    public AccountJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public boolean checkPassword(int accountId, Predicate<String> check) {
        String encodedPassword = (String)this.getFirstItem("SELECT PASSWORD FROM ACCOUNTS WHERE MODE = 'password' AND ID = :id", this.params("id", accountId), String.class);
        return encodedPassword != null && check.test(encodedPassword);
    }

    public Optional<Account> findUserByNameAndSource(String username, AuthenticationSourceProvider sourceProvider) {
        return Optional.ofNullable(this.getFirstItem("SELECT * FROM ACCOUNTS WHERE MODE = :mode AND NAME = :name", this.params("name", username).addValue("mode", (Object)sourceProvider.getSource().getId()), (rs, rowNum) -> this.toAccount(rs, mode -> sourceProvider.getSource())));
    }

    private Account toAccount(ResultSet rs, Function<String, AuthenticationSource> authenticationSourceFunction) throws SQLException {
        return Account.of((String)rs.getString("name"), (String)rs.getString("fullName"), (String)rs.getString("email"), (SecurityRole)((SecurityRole)this.getEnum(SecurityRole.class, rs, "role")), (AuthenticationSource)authenticationSourceFunction.apply(rs.getString("mode"))).withId(this.id(rs));
    }

    public Collection<Account> findAll(Function<String, AuthenticationSource> authenticationSourceFunction) {
        return this.getJdbcTemplate().query("SELECT * FROM ACCOUNTS ORDER BY NAME", (rs, num) -> this.toAccount(rs, authenticationSourceFunction));
    }

    public Account newAccount(Account account) {
        try {
            int id = this.dbCreate("INSERT INTO ACCOUNTS (NAME, FULLNAME, EMAIL, MODE, PASSWORD, ROLE) VALUES (:name, :fullName, :email, :mode, :password, :role)", this.params("name", account.getName()).addValue("fullName", (Object)account.getFullName()).addValue("email", (Object)account.getEmail()).addValue("mode", (Object)account.getAuthenticationSource().getId()).addValue("password", (Object)"").addValue("role", (Object)account.getRole().name()));
            return account.withId(ID.of((int)id));
        }
        catch (DuplicateKeyException ex) {
            throw new AccountNameAlreadyDefinedException(account.getName());
        }
    }

    public void saveAccount(Account account) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE ACCOUNTS SET NAME = :name, FULLNAME = :fullName, EMAIL = :email WHERE ID = :id", (SqlParameterSource)this.params("id", account.id()).addValue("name", (Object)account.getName()).addValue("fullName", (Object)account.getFullName()).addValue("email", (Object)account.getEmail()));
        }
        catch (DuplicateKeyException ex) {
            throw new AccountNameAlreadyDefinedException(account.getName());
        }
    }

    public Ack deleteAccount(ID accountId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM ACCOUNTS WHERE ID = :id", (SqlParameterSource)this.params("id", accountId.getValue())));
    }

    public void setPassword(int accountId, String encodedPassword) {
        this.getNamedParameterJdbcTemplate().update("UPDATE ACCOUNTS SET PASSWORD = :password WHERE ID = :id", (SqlParameterSource)this.params("id", accountId).addValue("password", (Object)encodedPassword));
    }

    public Account getAccount(ID accountId, Function<String, AuthenticationSource> authenticationSourceFunction) {
        return (Account)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM ACCOUNTS WHERE ID = :id", (SqlParameterSource)this.params("id", accountId.getValue()), (rs, num) -> this.toAccount(rs, authenticationSourceFunction));
    }

    public List<Account> findByNameToken(String token, Function<String, AuthenticationSource> authenticationSourceFunction) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM ACCOUNTS WHERE LOWER(NAME) LIKE :filter ORDER BY NAME", (SqlParameterSource)this.params("filter", String.format("%%%s%%", StringUtils.lowerCase((String)token))), (rs, num) -> this.toAccount(rs, authenticationSourceFunction));
    }

    public List<Account> getAccountsForGroup(AccountGroup accountGroup, Function<String, AuthenticationSource> authenticationSourceFunction) {
        return this.getNamedParameterJdbcTemplate().query("SELECT A.* FROM ACCOUNTS A INNER JOIN ACCOUNT_GROUP_LINK L ON L.ACCOUNT = A.ID WHERE L.ACCOUNTGROUP = :accountGroupId ORDER BY A.NAME ASC", (SqlParameterSource)this.params("accountGroupId", accountGroup.id()), (rs, num) -> this.toAccount(rs, authenticationSourceFunction));
    }
}

