/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.AccountGroupMappingNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.AccountGroupMappingNotFoundException;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.security.AccountGroupMapping;
import net.nemerosa.ontrack.model.security.AccountGroupMappingInput;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.repository.AccountGroupMappingRepository;
import net.nemerosa.ontrack.repository.AccountGroupRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AccountGroupMappingJdbcRepository
extends AbstractJdbcRepository
implements AccountGroupMappingRepository {
    private final AccountGroupRepository accountGroupRepository;

    @Autowired
    public AccountGroupMappingJdbcRepository(DataSource dataSource, AccountGroupRepository accountGroupRepository) {
        super(dataSource);
        this.accountGroupRepository = accountGroupRepository;
    }

    public Collection<AccountGroup> getGroups(String mapping, String mappedName) {
        return this.getNamedParameterJdbcTemplate().queryForList("SELECT GROUPID FROM ACCOUNT_GROUP_MAPPING WHERE MAPPING = :mapping AND SOURCE = :mappedName", (SqlParameterSource)this.params("mapping", mapping).addValue("mappedName", (Object)mappedName), Integer.class).stream().map(groupId -> this.accountGroupRepository.getById(ID.of((int)groupId))).collect(Collectors.toList());
    }

    public List<AccountGroupMapping> getMappings(String mapping) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM ACCOUNT_GROUP_MAPPING WHERE MAPPING = :mapping ORDER BY SOURCE", (SqlParameterSource)this.params("mapping", mapping), this::toAccountGroupMapping);
    }

    public AccountGroupMapping newMapping(String mapping, AccountGroupMappingInput input) {
        try {
            return this.getMapping(ID.of((int)this.dbCreate("INSERT INTO ACCOUNT_GROUP_MAPPING(MAPPING, SOURCE, GROUPID) VALUES(:mapping, :source, :groupId)", this.params("mapping", mapping).addValue("source", (Object)input.getName()).addValue("groupId", (Object)input.getGroup().get()))));
        }
        catch (DuplicateKeyException ex) {
            throw new AccountGroupMappingNameAlreadyDefinedException(input.getName());
        }
    }

    public AccountGroupMapping getMapping(ID id) {
        try {
            return (AccountGroupMapping)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM ACCOUNT_GROUP_MAPPING WHERE ID = :id", (SqlParameterSource)this.params("id", id.get()), this::toAccountGroupMapping);
        }
        catch (EmptyResultDataAccessException ex) {
            throw new AccountGroupMappingNotFoundException(id);
        }
    }

    public AccountGroupMapping updateMapping(ID id, AccountGroupMappingInput input) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE ACCOUNT_GROUP_MAPPING SET SOURCE = :source, GROUPID = :groupId WHERE ID = :id", (SqlParameterSource)this.params("id", id.get()).addValue("source", (Object)input.getName()).addValue("groupId", (Object)input.getGroup().get()));
            return this.getMapping(id);
        }
        catch (DuplicateKeyException ex) {
            throw new AccountGroupMappingNameAlreadyDefinedException(input.getName());
        }
    }

    public Ack deleteMapping(ID id) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM ACCOUNT_GROUP_MAPPING WHERE ID = :id", (SqlParameterSource)this.params("id", id.get())));
    }

    public List<AccountGroupMapping> getMappingsForGroup(AccountGroup group) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM ACCOUNT_GROUP_MAPPING WHERE GROUPID = :groupId", (SqlParameterSource)this.params("groupId", group.id()), this::toAccountGroupMapping);
    }

    protected AccountGroupMapping toAccountGroupMapping(ResultSet rs, int rowNum) throws SQLException {
        return new AccountGroupMapping(this.id(rs), rs.getString("MAPPING"), rs.getString("SOURCE"), this.accountGroupRepository.getById(this.id(rs, "GROUPID")));
    }
}

