/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.exceptions.AccountGroupNameAlreadyDefinedException;
import net.nemerosa.ontrack.model.exceptions.AccountGroupNotFoundException;
import net.nemerosa.ontrack.model.security.AccountGroup;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.repository.AccountGroupRepository;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AccountGroupJdbcRepository
extends AbstractJdbcRepository
implements AccountGroupRepository {
    @Autowired
    public AccountGroupJdbcRepository(DataSource dataSource) {
        super(dataSource);
    }

    public Collection<AccountGroup> findByAccount(int accountId) {
        return this.getNamedParameterJdbcTemplate().query("SELECT G.* FROM ACCOUNT_GROUPS G INNER JOIN ACCOUNT_GROUP_LINK L ON L.ACCOUNTGROUP = G.ID WHERE L.ACCOUNT = :accountId", (SqlParameterSource)this.params("accountId", accountId), (rs, num) -> this.toAccountGroup(rs));
    }

    public void linkAccountToGroups(int accountId, Collection<Integer> groupIds) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM ACCOUNT_GROUP_LINK WHERE ACCOUNT = :accountId", (SqlParameterSource)this.params("accountId", accountId));
        if (groupIds != null) {
            for (int groupId : groupIds) {
                this.getNamedParameterJdbcTemplate().update("INSERT INTO ACCOUNT_GROUP_LINK (ACCOUNT, ACCOUNTGROUP) VALUES (:accountId, :groupId)", (SqlParameterSource)this.params("accountId", accountId).addValue("groupId", (Object)groupId));
            }
        }
    }

    public List<AccountGroup> findByNameToken(String token) {
        return this.getNamedParameterJdbcTemplate().query("SELECT * FROM ACCOUNT_GROUPS WHERE LOWER(NAME) LIKE :filter ORDER BY NAME", (SqlParameterSource)this.params("filter", String.format("%%%s%%", StringUtils.lowerCase((String)token))), (rs, num) -> this.toAccountGroup(rs));
    }

    private AccountGroup toAccountGroup(ResultSet rs) throws SQLException {
        return AccountGroup.of((String)rs.getString("name"), (String)rs.getString("description")).withId(this.id(rs));
    }

    public List<AccountGroup> findAll() {
        return this.getJdbcTemplate().query("SELECT * FROM ACCOUNT_GROUPS ORDER BY NAME", (rs, num) -> this.toAccountGroup(rs));
    }

    public AccountGroup newAccountGroup(AccountGroup group) {
        try {
            return group.withId(ID.of((int)this.dbCreate("INSERT INTO ACCOUNT_GROUPS (NAME, DESCRIPTION) VALUES (:name, :description)", this.params("name", group.getName()).addValue("description", (Object)group.getDescription()))));
        }
        catch (DuplicateKeyException ex) {
            throw new AccountGroupNameAlreadyDefinedException(group.getName());
        }
    }

    public AccountGroup getById(ID groupId) {
        try {
            return (AccountGroup)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM ACCOUNT_GROUPS WHERE ID = :id", (SqlParameterSource)this.params("id", groupId.getValue()), (rs, num) -> this.toAccountGroup(rs));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new AccountGroupNotFoundException(groupId);
        }
    }

    public void update(AccountGroup group) {
        try {
            this.getNamedParameterJdbcTemplate().update("UPDATE ACCOUNT_GROUPS SET NAME = :name, DESCRIPTION = :description WHERE ID = :id", (SqlParameterSource)this.params("name", group.getName()).addValue("description", (Object)group.getDescription()).addValue("id", (Object)group.id()));
        }
        catch (DuplicateKeyException ex) {
            throw new AccountGroupNameAlreadyDefinedException(group.getName());
        }
    }

    public Ack delete(ID groupId) {
        return Ack.one((int)this.getNamedParameterJdbcTemplate().update("DELETE FROM ACCOUNT_GROUPS WHERE ID = :id", (SqlParameterSource)this.params("id", groupId.getValue())));
    }
}

