-- 6. Branch templating

CREATE TABLE BRANCH_TEMPLATE_DEFINITIONS (
  BRANCHID                    INTEGER     NOT NULL,
  ABSENCEPOLICY               VARCHAR(20) NOT NULL,
  SYNCINTERVAL                INTEGER     NOT NULL,
  SYNCHRONISATIONSOURCEID     VARCHAR(20) NOT NULL,
  SYNCHRONISATIONSOURCECONFIG TEXT,
  CONSTRAINT BRANCH_TEMPLATE_DEFINITIONS_PK PRIMARY KEY (BRANCHID),
  CONSTRAINT BRANCH_TEMPLATE_DEFINITIONS_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE
);

CREATE TABLE BRANCH_TEMPLATE_DEFINITION_PARAMS (
  BRANCHID    INTEGER      NOT NULL,
  NAME        VARCHAR(120) NOT NULL,
  DESCRIPTION VARCHAR(500) NOT NULL,
  EXPRESSION  VARCHAR(500) NOT NULL,
  CONSTRAINT BRANCH_TEMPLATE_DEFINITION_PARAMS_PK PRIMARY KEY (BRANCHID, NAME),
  CONSTRAINT BRANCH_TEMPLATE_DEFINITION_PARAMS_FK_BRANCH_TEMPLATE_DEFINITION FOREIGN KEY (BRANCHID) REFERENCES BRANCH_TEMPLATE_DEFINITIONS (BRANCHID)
    ON DELETE CASCADE
);

CREATE TABLE BRANCH_TEMPLATE_INSTANCES (
  BRANCHID         INTEGER NOT NULL,
  TEMPLATEBRANCHID INTEGER NOT NULL,
  CONSTRAINT BRANCH_TEMPLATE_INSTANCES_PK PRIMARY KEY (BRANCHID),
  CONSTRAINT BRANCH_TEMPLATE_INSTANCES_FK_BRANCH FOREIGN KEY (BRANCHID) REFERENCES BRANCHES (ID) ON DELETE CASCADE,
  CONSTRAINT BRANCH_TEMPLATE_INSTANCES_FK_TEMPLATEBRANCH FOREIGN KEY (TEMPLATEBRANCHID) REFERENCES BRANCHES (ID)
    ON DELETE CASCADE
);

CREATE TABLE BRANCH_TEMPLATE_INSTANCE_PARAMS (
  BRANCHID INTEGER      NOT NULL,
  NAME     VARCHAR(120) NOT NULL,
  VALUE    VARCHAR(500) NOT NULL,
  CONSTRAINT BRANCH_TEMPLATE_INSTANCE_PARAMS_PK PRIMARY KEY (BRANCHID, NAME),
  CONSTRAINT BRANCH_TEMPLATE_INSTANCE_PARAMS_FK_BRANCH_TEMPLATE_INSTANCE FOREIGN KEY (BRANCHID) REFERENCES BRANCH_TEMPLATE_INSTANCES (BRANCHID)
    ON DELETE CASCADE
);

-- @rollback

DROP TABLE BRANCH_TEMPLATE_INSTANCE_PARAMS;
DROP TABLE BRANCH_TEMPLATE_INSTANCES;
DROP TABLE BRANCH_TEMPLATE_DEFINITION_PARAMS;
DROP TABLE BRANCH_TEMPLATE_DEFINITIONS;
