/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support.tree.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

public class Markup {
    private final String type;
    private final String text;
    private final Map<String, String> attributes;

    public static Markup text(String text) {
        return new Markup(null, text, null);
    }

    public static Markup of(String type) {
        return new Markup(type, null, new HashMap<String, String>());
    }

    public static Markup of(String type, Map<String, String> attributes) {
        return Markup.of(type).attrs(attributes);
    }

    public Markup attrs(Map<String, String> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public Markup attr(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    @JsonIgnore
    public boolean isOnlyText() {
        return this.type == null;
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Markup)) {
            return false;
        }
        Markup other = (Markup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Markup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "Markup(type=" + this.getType() + ", text=" + this.getText() + ", attributes=" + this.getAttributes() + ")";
    }

    @ConstructorProperties(value={"type", "text", "attributes"})
    protected Markup(String type, String text, Map<String, String> attributes) {
        this.type = type;
        this.text = text;
        this.attributes = attributes;
    }
}

