/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.model.support.tree.Node;
import net.nemerosa.ontrack.model.support.tree.NodeFactory;
import net.nemerosa.ontrack.model.support.tree.NodeTransformer;
import net.nemerosa.ontrack.model.support.tree.NodeVisitor;

public class DefaultNode<D>
implements Node<D> {
    private final NodeFactory<D> factory;
    private final D data;
    private final List<Node<D>> children;

    public DefaultNode(NodeFactory<D> factory, D data) {
        this(factory, data, Collections.emptyList());
    }

    public DefaultNode(NodeFactory<D> factory, D data, Collection<Node<D>> children) {
        this.factory = factory;
        this.data = data;
        this.children = new ArrayList<Node<D>>(children);
    }

    @Override
    public Iterable<Node<D>> getChildren() {
        return this.children;
    }

    @Override
    public Node<D> append(Node<D> child) {
        this.children.add(child);
        return this;
    }

    @Override
    public void visit(NodeVisitor<D> nodeVisitor) {
        nodeVisitor.start(this);
        for (Node<D> child : this.children) {
            child.visit(nodeVisitor);
        }
        nodeVisitor.end(this);
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    @JsonIgnore
    public NodeFactory<D> getFactory() {
        return this.factory;
    }

    @Override
    @JsonIgnore
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    @Override
    public Node<D> transform(NodeTransformer<D> transformer) {
        return this.transform(transformer, this.factory);
    }

    @Override
    public Node<D> transform(NodeTransformer<D> transformer, NodeFactory<D> factory) {
        Node<D> t;
        if (this.isLeaf()) {
            t = factory.leaf(this.data);
        } else {
            ArrayList newKids = new ArrayList();
            for (Node<D> child : this.children) {
                Node<D> newKid = child.transform(transformer, factory);
                if (newKid.getData() == null) {
                    for (Node<D> grandChild : newKid.getChildren()) {
                        newKids.add(grandChild);
                    }
                    continue;
                }
                newKids.add(newKid);
            }
            t = factory.node(this.data, newKids);
        }
        return transformer.transform(t);
    }

    public String toString() {
        return "DefaultNode(factory=" + this.getFactory() + ", data=" + this.getData() + ", children=" + this.getChildren() + ")";
    }
}

