/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.model.structure.VersionInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ontrack.version")
public class VersionInfoConfig {
    private static final Logger logger = LoggerFactory.getLogger(VersionInfoConfig.class);
    private String date;
    private String display = "n/a";
    private String full = "n/a";
    private String branch = "n/a";
    private String build = "0";
    private String commit = "NA";
    private String source = "source";
    private String sourceType = "sourceType";

    public VersionInfo toInfo() {
        return new VersionInfo(VersionInfoConfig.parseDate(this.date), this.display, this.full, this.branch, this.build, this.commit, this.source, this.sourceType);
    }

    public static LocalDateTime parseDate(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            logger.info("[version-info] No date defined, using current date.");
            return Time.now();
        }
        try {
            return LocalDateTime.parse(value, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        }
        catch (DateTimeParseException ex) {
            logger.warn("[version-info] Wrong date format, using current date: " + value);
            return Time.now();
        }
    }

    public String getDate() {
        return this.date;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getFull() {
        return this.full;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuild() {
        return this.build;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setFull(String full) {
        this.full = full;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setCommit(String commit) {
        this.commit = commit;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfoConfig)) {
            return false;
        }
        VersionInfoConfig other = (VersionInfoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$display = this.getDisplay();
        String other$display = other.getDisplay();
        if (this$display == null ? other$display != null : !this$display.equals(other$display)) {
            return false;
        }
        String this$full = this.getFull();
        String other$full = other.getFull();
        if (this$full == null ? other$full != null : !this$full.equals(other$full)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$commit = this.getCommit();
        String other$commit = other.getCommit();
        if (this$commit == null ? other$commit != null : !this$commit.equals(other$commit)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$sourceType = this.getSourceType();
        String other$sourceType = other.getSourceType();
        return !(this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $display = this.getDisplay();
        result = result * 59 + ($display == null ? 43 : $display.hashCode());
        String $full = this.getFull();
        result = result * 59 + ($full == null ? 43 : $full.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $commit = this.getCommit();
        result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfoConfig(date=" + this.getDate() + ", display=" + this.getDisplay() + ", full=" + this.getFull() + ", branch=" + this.getBranch() + ", build=" + this.getBuild() + ", commit=" + this.getCommit() + ", source=" + this.getSource() + ", sourceType=" + this.getSourceType() + ")";
    }
}

