/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import java.util.function.Function;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.UserPassword;
import org.apache.commons.lang3.StringUtils;

public interface UserPasswordConfiguration<T extends UserPasswordConfiguration<T>>
extends Configuration<T> {
    @Override
    public String getName();

    public String getUser();

    public String getPassword();

    public T withPassword(String var1);

    public T clone(String var1, Function<String, String> var2);

    @JsonIgnore
    default public Optional<UserPassword> getCredentials() {
        String user = this.getUser();
        if (StringUtils.isNotBlank((CharSequence)user)) {
            return Optional.of(new UserPassword(user, this.getPassword()));
        }
        return Optional.empty();
    }
}

