/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.json.JsonUtils;

public interface StorageService {
    public void storeJson(String var1, String var2, JsonNode var3);

    public Optional<JsonNode> retrieveJson(String var1, String var2);

    public List<String> getKeys(String var1);

    public Map<String, JsonNode> getData(String var1);

    default public void store(String store, String key, Object data) {
        this.storeJson(store, key, JsonUtils.format((Object)data));
    }

    default public <T> Optional<T> retrieve(String store, String key, Class<T> type) {
        return this.retrieveJson(store, key).map(node -> JsonUtils.parse((JsonNode)node, (Class)type));
    }

    default public <T> Map<String, T> getData(String store, Class<T> type) {
        return this.getData(store).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> JsonUtils.parse((JsonNode)((JsonNode)entry.getValue()), (Class)type)));
    }
}

