/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.support.Selectable;

public class SelectableItem
implements Selectable {
    private final boolean selected;
    private final String id;
    private final String name;

    public static <T> List<SelectableItem> listOf(Collection<T> items, Function<T, String> idFn, Function<T, String> nameFn, Predicate<T> selectedFn) {
        return items.stream().map(i -> new SelectableItem(selectedFn.test(i), (String)idFn.apply(i), (String)nameFn.apply(i))).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"selected", "id", "name"})
    public SelectableItem(boolean selected, String id, String name) {
        this.selected = selected;
        this.id = id;
        this.name = name;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectableItem)) {
            return false;
        }
        SelectableItem other = (SelectableItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectableItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelected() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "SelectableItem(selected=" + this.isSelected() + ", id=" + this.getId() + ", name=" + this.getName() + ")";
    }
}

