/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.model.support.AbstractMessageAnnotator;
import net.nemerosa.ontrack.model.support.MessageAnnotation;

public class RegexMessageAnnotator
extends AbstractMessageAnnotator {
    private final Pattern pattern;
    private final Function<String, MessageAnnotation> annotationFactory;

    public RegexMessageAnnotator(String pattern, Function<String, MessageAnnotation> annotationFactory) {
        this(Pattern.compile(pattern), annotationFactory);
    }

    public RegexMessageAnnotator(Pattern pattern, Function<String, MessageAnnotation> annotationFactory) {
        this.pattern = pattern;
        this.annotationFactory = annotationFactory;
    }

    @Override
    public Collection<MessageAnnotation> annotate(String text) {
        ArrayList<MessageAnnotation> annotations = new ArrayList<MessageAnnotation>();
        int start = 0;
        Matcher m = this.pattern.matcher(text);
        while (m.find()) {
            int mStart = m.start();
            int mEnd = m.end();
            if (mStart > start) {
                String previous = text.substring(start, mStart);
                annotations.add(MessageAnnotation.t(previous));
            }
            String match = m.group();
            MessageAnnotation annotation = this.annotationFactory.apply(match);
            annotations.add(annotation);
            start = mEnd;
        }
        if (start < text.length() - 1) {
            String reminder = text.substring(start);
            annotations.add(MessageAnnotation.t(reminder));
        }
        return annotations;
    }
}

