/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import javax.annotation.PostConstruct;
import net.nemerosa.ontrack.model.support.JobConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ontrack.config")
public class OntrackConfigProperties {
    private final Logger logger = LoggerFactory.getLogger(OntrackConfigProperties.class);
    private int applicationLogRetentionDays = 7;
    private int applicationLogInfoMax = 10;
    private String applicationWorkingDir = "work/files";
    private int metricsPeriod = 60;
    private boolean configurationTest = true;
    private JobConfigProperties jobs = new JobConfigProperties();

    @PostConstruct
    public void log() {
        if (!this.configurationTest) {
            this.logger.warn("[config] Tests of external configurations are disabled");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getApplicationLogRetentionDays() {
        return this.applicationLogRetentionDays;
    }

    public int getApplicationLogInfoMax() {
        return this.applicationLogInfoMax;
    }

    public String getApplicationWorkingDir() {
        return this.applicationWorkingDir;
    }

    public int getMetricsPeriod() {
        return this.metricsPeriod;
    }

    public boolean isConfigurationTest() {
        return this.configurationTest;
    }

    public JobConfigProperties getJobs() {
        return this.jobs;
    }

    public void setApplicationLogRetentionDays(int applicationLogRetentionDays) {
        this.applicationLogRetentionDays = applicationLogRetentionDays;
    }

    public void setApplicationLogInfoMax(int applicationLogInfoMax) {
        this.applicationLogInfoMax = applicationLogInfoMax;
    }

    public void setApplicationWorkingDir(String applicationWorkingDir) {
        this.applicationWorkingDir = applicationWorkingDir;
    }

    public void setMetricsPeriod(int metricsPeriod) {
        this.metricsPeriod = metricsPeriod;
    }

    public void setConfigurationTest(boolean configurationTest) {
        this.configurationTest = configurationTest;
    }

    public void setJobs(JobConfigProperties jobs) {
        this.jobs = jobs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OntrackConfigProperties)) {
            return false;
        }
        OntrackConfigProperties other = (OntrackConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        if (this.getApplicationLogRetentionDays() != other.getApplicationLogRetentionDays()) {
            return false;
        }
        if (this.getApplicationLogInfoMax() != other.getApplicationLogInfoMax()) {
            return false;
        }
        String this$applicationWorkingDir = this.getApplicationWorkingDir();
        String other$applicationWorkingDir = other.getApplicationWorkingDir();
        if (this$applicationWorkingDir == null ? other$applicationWorkingDir != null : !this$applicationWorkingDir.equals(other$applicationWorkingDir)) {
            return false;
        }
        if (this.getMetricsPeriod() != other.getMetricsPeriod()) {
            return false;
        }
        if (this.isConfigurationTest() != other.isConfigurationTest()) {
            return false;
        }
        JobConfigProperties this$jobs = this.getJobs();
        JobConfigProperties other$jobs = other.getJobs();
        return !(this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OntrackConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        result = result * 59 + this.getApplicationLogRetentionDays();
        result = result * 59 + this.getApplicationLogInfoMax();
        String $applicationWorkingDir = this.getApplicationWorkingDir();
        result = result * 59 + ($applicationWorkingDir == null ? 43 : $applicationWorkingDir.hashCode());
        result = result * 59 + this.getMetricsPeriod();
        result = result * 59 + (this.isConfigurationTest() ? 79 : 97);
        JobConfigProperties $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        return result;
    }

    public String toString() {
        return "OntrackConfigProperties(logger=" + this.getLogger() + ", applicationLogRetentionDays=" + this.getApplicationLogRetentionDays() + ", applicationLogInfoMax=" + this.getApplicationLogInfoMax() + ", applicationWorkingDir=" + this.getApplicationWorkingDir() + ", metricsPeriod=" + this.getMetricsPeriod() + ", configurationTest=" + this.isConfigurationTest() + ", jobs=" + this.getJobs() + ")";
    }
}

