/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.model.support.MessageAnnotation;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import net.nemerosa.ontrack.model.support.tree.DefaultNodeFactory;
import net.nemerosa.ontrack.model.support.tree.Node;
import net.nemerosa.ontrack.model.support.tree.NodeVisitor;
import net.nemerosa.ontrack.model.support.tree.support.Markup;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public final class MessageAnnotationUtils {
    public static String annotate(String text, List<? extends MessageAnnotator> messageAnnotators) {
        Node<Markup> root = MessageAnnotationUtils.annotateAsNode(text, messageAnnotators);
        final StringBuilder html = new StringBuilder();
        root.visit(new NodeVisitor<Markup>(){

            @Override
            public void start(Node<Markup> node) {
                Markup m = node.getData();
                if (m != null) {
                    if (m.isOnlyText()) {
                        html.append(StringEscapeUtils.escapeHtml4((String)m.getText()));
                    } else {
                        html.append("<").append(m.getType());
                        Map<String, String> attributes = m.getAttributes();
                        for (Map.Entry<String, String> attr : attributes.entrySet()) {
                            html.append(" ").append(StringEscapeUtils.escapeHtml4((String)attr.getKey())).append("=\"").append(StringEscapeUtils.escapeHtml4((String)attr.getValue())).append("\"");
                        }
                        if (node.isLeaf()) {
                            html.append("/>");
                        } else {
                            html.append(">");
                        }
                    }
                }
            }

            @Override
            public void end(Node<Markup> node) {
                Markup m = node.getData();
                if (m != null && !m.isOnlyText() && !node.isLeaf()) {
                    html.append("</").append(m.getType()).append(">");
                }
            }
        });
        return html.toString();
    }

    public static Node<Markup> annotateAsNode(String text, List<? extends MessageAnnotator> messageAnnotators) {
        DefaultNodeFactory<Markup> factory = new DefaultNodeFactory<Markup>();
        Node<Markup> root = factory.leaf(Markup.text(text));
        if (messageAnnotators != null) {
            for (MessageAnnotator messageAnnotator : messageAnnotators) {
                if (messageAnnotator == null) continue;
                root = root.transform(node -> {
                    String text1;
                    if (node.isLeaf() && StringUtils.isNotBlank((CharSequence)(text1 = ((Markup)node.getData()).getText()))) {
                        Collection<MessageAnnotation> annotations = messageAnnotator.annotate(text1);
                        ArrayList nodes = new ArrayList();
                        for (MessageAnnotation annotation : annotations) {
                            if (annotation.isText()) {
                                nodes.add(factory.leaf(Markup.text(annotation.getText())));
                                continue;
                            }
                            Node<Markup> child = factory.leaf(Markup.of(annotation.getType(), annotation.getAttributes()));
                            if (annotation.hasText()) {
                                child.append(factory.leaf(Markup.text(annotation.getText())));
                            }
                            nodes.add(child);
                        }
                        return factory.node(null, nodes);
                    }
                    return node;
                }, factory);
            }
        }
        return root;
    }
}

