/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MessageAnnotation {
    private final String type;
    private final String text;
    private final Map<String, String> attributes;

    public static MessageAnnotation of(String type) {
        return new MessageAnnotation(type, null, new HashMap<String, String>());
    }

    public static MessageAnnotation t(String text) {
        return MessageAnnotation.of(null).text(text);
    }

    public MessageAnnotation attr(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String attr(String name) {
        return this.attributes.get(name);
    }

    public MessageAnnotation text(String text) {
        return new MessageAnnotation(this.type, text, this.attributes);
    }

    public boolean isText() {
        return this.type == null;
    }

    public boolean hasText() {
        return StringUtils.isNotBlank((CharSequence)this.text);
    }

    public String getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageAnnotation)) {
            return false;
        }
        MessageAnnotation other = (MessageAnnotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "MessageAnnotation(type=" + this.getType() + ", text=" + this.getText() + ", attributes=" + this.getAttributes() + ")";
    }

    @ConstructorProperties(value={"type", "text", "attributes"})
    protected MessageAnnotation(String type, String text, Map<String, String> attributes) {
        this.type = type;
        this.text = text;
        this.attributes = attributes;
    }
}

