/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import org.apache.commons.lang3.Validate;

public class JobConfigProperties {
    private int poolSize = 10;
    private int orchestration = 2;
    private boolean pausedAtStartup = false;
    private boolean scattering = false;
    private double scatteringRatio = 1.0;

    public void setScatteringRatio(double value) {
        Validate.inclusiveBetween((double)0.0, (double)1.0, (double)value);
        this.scatteringRatio = value;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getOrchestration() {
        return this.orchestration;
    }

    public boolean isPausedAtStartup() {
        return this.pausedAtStartup;
    }

    public boolean isScattering() {
        return this.scattering;
    }

    public double getScatteringRatio() {
        return this.scatteringRatio;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setOrchestration(int orchestration) {
        this.orchestration = orchestration;
    }

    public void setPausedAtStartup(boolean pausedAtStartup) {
        this.pausedAtStartup = pausedAtStartup;
    }

    public void setScattering(boolean scattering) {
        this.scattering = scattering;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobConfigProperties)) {
            return false;
        }
        JobConfigProperties other = (JobConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getOrchestration() != other.getOrchestration()) {
            return false;
        }
        if (this.isPausedAtStartup() != other.isPausedAtStartup()) {
            return false;
        }
        if (this.isScattering() != other.isScattering()) {
            return false;
        }
        return Double.compare(this.getScatteringRatio(), other.getScatteringRatio()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoolSize();
        result = result * 59 + this.getOrchestration();
        result = result * 59 + (this.isPausedAtStartup() ? 79 : 97);
        result = result * 59 + (this.isScattering() ? 79 : 97);
        long $scatteringRatio = Double.doubleToLongBits(this.getScatteringRatio());
        result = result * 59 + (int)($scatteringRatio >>> 32 ^ $scatteringRatio);
        return result;
    }

    public String toString() {
        return "JobConfigProperties(poolSize=" + this.getPoolSize() + ", orchestration=" + this.getOrchestration() + ", pausedAtStartup=" + this.isPausedAtStartup() + ", scattering=" + this.isScattering() + ", scatteringRatio=" + this.getScatteringRatio() + ")";
    }
}

