/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import java.beans.ConstructorProperties;
import java.util.function.Function;

public class ConnectionResult {
    private final ConnectionResultType type;
    private final String message;

    public static ConnectionResult ok() {
        return new ConnectionResult(ConnectionResultType.OK, "");
    }

    public static ConnectionResult error(String message) {
        return new ConnectionResult(ConnectionResultType.ERROR, message);
    }

    public void onErrorThrow(Function<String, ? extends RuntimeException> errorCreation) {
        if (this.type == ConnectionResultType.ERROR) {
            throw errorCreation.apply(this.message);
        }
    }

    @ConstructorProperties(value={"type", "message"})
    public ConnectionResult(ConnectionResultType type, String message) {
        this.type = type;
        this.message = message;
    }

    public ConnectionResultType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult other = (ConnectionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConnectionResultType this$type = this.getType();
        ConnectionResultType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionResultType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionResult(type=" + (Object)((Object)this.getType()) + ", message=" + this.getMessage() + ")";
    }

    public static enum ConnectionResultType {
        OK,
        ERROR;

    }
}

