/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.support.ApplicationLogEntryLevel;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ApplicationLogEntry {
    private final ApplicationLogEntryLevel level;
    private final LocalDateTime timestamp;
    private final String authentication;
    private final NameDescription type;
    private final String information;
    private final String stacktrace;
    private final Map<String, String> details;

    public static ApplicationLogEntry fatal(Throwable exception, NameDescription type, String information) {
        return ApplicationLogEntry.create(ApplicationLogEntryLevel.FATAL, exception, type, information);
    }

    public static ApplicationLogEntry error(Throwable exception, NameDescription type, String information) {
        return ApplicationLogEntry.create(ApplicationLogEntryLevel.ERROR, exception, type, information);
    }

    private static ApplicationLogEntry create(ApplicationLogEntryLevel level, Throwable exception, NameDescription type, String information) {
        return new ApplicationLogEntry(level, Time.now(), null, type, information, null, Collections.emptyMap()).withStacktrace(ExceptionUtils.getStackTrace((Throwable)exception));
    }

    public ApplicationLogEntry withDetail(String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>(this.details);
        map.put(name, value);
        return this.withDetails(map);
    }

    @JsonIgnore
    public Map<String, String> getDetails() {
        return this.details;
    }

    public List<NameDescription> getDetailList() {
        return this.details.entrySet().stream().map(entry -> NameDescription.nd((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public ApplicationLogEntryLevel getLevel() {
        return this.level;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public NameDescription getType() {
        return this.type;
    }

    public String getInformation() {
        return this.information;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationLogEntry)) {
            return false;
        }
        ApplicationLogEntry other = (ApplicationLogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationLogEntryLevel this$level = this.getLevel();
        ApplicationLogEntryLevel other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$authentication = this.getAuthentication();
        String other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        NameDescription this$type = this.getType();
        NameDescription other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$information = this.getInformation();
        String other$information = other.getInformation();
        if (this$information == null ? other$information != null : !this$information.equals(other$information)) {
            return false;
        }
        String this$stacktrace = this.getStacktrace();
        String other$stacktrace = other.getStacktrace();
        if (this$stacktrace == null ? other$stacktrace != null : !this$stacktrace.equals(other$stacktrace)) {
            return false;
        }
        Map<String, String> this$details = this.getDetails();
        Map<String, String> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationLogEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationLogEntryLevel $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        NameDescription $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $information = this.getInformation();
        result = result * 59 + ($information == null ? 43 : $information.hashCode());
        String $stacktrace = this.getStacktrace();
        result = result * 59 + ($stacktrace == null ? 43 : $stacktrace.hashCode());
        Map<String, String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }

    public String toString() {
        return "ApplicationLogEntry(level=" + (Object)((Object)this.getLevel()) + ", timestamp=" + this.getTimestamp() + ", authentication=" + this.getAuthentication() + ", type=" + this.getType() + ", information=" + this.getInformation() + ", stacktrace=" + this.getStacktrace() + ", details=" + this.getDetails() + ")";
    }

    @ConstructorProperties(value={"level", "timestamp", "authentication", "type", "information", "stacktrace", "details"})
    public ApplicationLogEntry(ApplicationLogEntryLevel level, LocalDateTime timestamp, String authentication, NameDescription type, String information, String stacktrace, Map<String, String> details) {
        this.level = level;
        this.timestamp = timestamp;
        this.authentication = authentication;
        this.type = type;
        this.information = information;
        this.stacktrace = stacktrace;
        this.details = details;
    }

    public ApplicationLogEntry withAuthentication(String authentication) {
        return this.authentication == authentication ? this : new ApplicationLogEntry(this.level, this.timestamp, authentication, this.type, this.information, this.stacktrace, this.details);
    }

    private ApplicationLogEntry withStacktrace(String stacktrace) {
        return this.stacktrace == stacktrace ? this : new ApplicationLogEntry(this.level, this.timestamp, this.authentication, this.type, this.information, stacktrace, this.details);
    }

    private ApplicationLogEntry withDetails(Map<String, String> details) {
        return this.details == details ? this : new ApplicationLogEntry(this.level, this.timestamp, this.authentication, this.type, this.information, this.stacktrace, details);
    }
}

