/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.User;

public class ValidationStamp
implements ProjectEntity {
    private final ID id;
    private final String name;
    private final String description;
    @JsonView(value={ValidationStamp.class})
    private final Branch branch;
    private final User owner;
    private final Boolean image;
    private final Signature signature;

    public static ValidationStamp of(Branch branch, NameDescription nameDescription) {
        Entity.isEntityDefined(branch, "Branch must be defined");
        Entity.isEntityDefined(branch.getProject(), "Project must be defined");
        return new ValidationStamp(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), branch, null, false, Signature.none());
    }

    @Override
    public Project getProject() {
        return this.getBranch().getProject();
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.VALIDATION_STAMP;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Validation stamp %s/%s/%s", this.branch.getProject().getName(), this.branch.getName(), this.name);
    }

    public ValidationStamp withId(ID id) {
        return new ValidationStamp(id, this.name, this.description, this.branch, this.owner, this.image, this.signature);
    }

    public ValidationStamp withImage(boolean image) {
        return new ValidationStamp(this.id, this.name, this.description, this.branch, this.owner, image, this.signature);
    }

    public static Form form() {
        return Form.nameAndDescription();
    }

    public Form asForm() {
        return ValidationStamp.form().fill("name", this.name).fill("description", this.description);
    }

    public ValidationStamp update(NameDescription nameDescription) {
        return new ValidationStamp(this.id, nameDescription.getName(), nameDescription.getDescription(), this.branch, this.owner, this.image, this.signature);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public User getOwner() {
        return this.owner;
    }

    public Boolean getImage() {
        return this.image;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationStamp)) {
            return false;
        }
        ValidationStamp other = (ValidationStamp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Branch this$branch = this.getBranch();
        Branch other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !((Object)this$branch).equals(other$branch)) {
            return false;
        }
        User this$owner = this.getOwner();
        User other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Boolean this$image = this.getImage();
        Boolean other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationStamp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Branch $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : ((Object)$branch).hashCode());
        User $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Boolean $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationStamp(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", branch=" + this.getBranch() + ", owner=" + this.getOwner() + ", image=" + this.getImage() + ", signature=" + this.getSignature() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "branch", "owner", "image", "signature"})
    protected ValidationStamp(ID id, String name, String description, Branch branch, User owner, Boolean image, Signature signature) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.branch = branch;
        this.owner = owner;
        this.image = image;
        this.signature = signature;
    }

    public ValidationStamp withDescription(String description) {
        return this.description == description ? this : new ValidationStamp(this.id, this.name, description, this.branch, this.owner, this.image, this.signature);
    }

    public ValidationStamp withSignature(Signature signature) {
        return this.signature == signature ? this : new ValidationStamp(this.id, this.name, this.description, this.branch, this.owner, this.image, signature);
    }
}

