/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ValidationRunStatusID {
    public static final String DEFECTIVE = "DEFECTIVE";
    public static final ValidationRunStatusID STATUS_DEFECTIVE = ValidationRunStatusID.of("DEFECTIVE", "Defective", false, false);
    public static final String EXPLAINED = "EXPLAINED";
    public static final ValidationRunStatusID STATUS_EXPLAINED = ValidationRunStatusID.of("EXPLAINED", "Explained", false, false);
    public static final String FAILED = "FAILED";
    public static final ValidationRunStatusID STATUS_FAILED = ValidationRunStatusID.of("FAILED", "Failed", true, false);
    public static final String FIXED = "FIXED";
    public static final ValidationRunStatusID STATUS_FIXED = ValidationRunStatusID.of("FIXED", "Fixed", false, true);
    public static final String INTERRUPTED = "INTERRUPTED";
    public static final ValidationRunStatusID STATUS_INTERRUPTED = ValidationRunStatusID.of("INTERRUPTED", "Interrupted", true, false);
    public static final String INVESTIGATING = "INVESTIGATING";
    public static final ValidationRunStatusID STATUS_INVESTIGATING = ValidationRunStatusID.of("INVESTIGATING", "Investigating", true, false);
    public static final String PASSED = "PASSED";
    public static final ValidationRunStatusID STATUS_PASSED = ValidationRunStatusID.of("PASSED", "Passed", true, true);
    public static final String WARNING = "WARNING";
    public static final ValidationRunStatusID STATUS_WARNING = ValidationRunStatusID.of("WARNING", "Warning", true, true);
    private final String id;
    private final String name;
    private final boolean root;
    private final boolean passed;
    private final Collection<String> followingStatuses;

    public ValidationRunStatusID addDependencies(String ... followingStatuses) {
        ArrayList<String> dependencies = new ArrayList<String>(this.followingStatuses);
        dependencies.addAll(Arrays.asList(followingStatuses));
        return new ValidationRunStatusID(this.id, this.name, this.root, this.passed, Collections.unmodifiableList(dependencies));
    }

    public static ValidationRunStatusID of(String id, String name, boolean root, boolean passed) {
        return new ValidationRunStatusID(id, name, root, passed, Collections.emptyList());
    }

    @ConstructorProperties(value={"id", "name", "root", "passed", "followingStatuses"})
    public ValidationRunStatusID(String id, String name, boolean root, boolean passed, Collection<String> followingStatuses) {
        this.id = id;
        this.name = name;
        this.root = root;
        this.passed = passed;
        this.followingStatuses = followingStatuses;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isPassed() {
        return this.passed;
    }

    public Collection<String> getFollowingStatuses() {
        return this.followingStatuses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationRunStatusID)) {
            return false;
        }
        ValidationRunStatusID other = (ValidationRunStatusID)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isRoot() != other.isRoot()) {
            return false;
        }
        if (this.isPassed() != other.isPassed()) {
            return false;
        }
        Collection<String> this$followingStatuses = this.getFollowingStatuses();
        Collection<String> other$followingStatuses = other.getFollowingStatuses();
        return !(this$followingStatuses == null ? other$followingStatuses != null : !((Object)this$followingStatuses).equals(other$followingStatuses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationRunStatusID;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.isRoot() ? 79 : 97);
        result = result * 59 + (this.isPassed() ? 79 : 97);
        Collection<String> $followingStatuses = this.getFollowingStatuses();
        result = result * 59 + ($followingStatuses == null ? 43 : ((Object)$followingStatuses).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationRunStatusID(id=" + this.getId() + ", name=" + this.getName() + ", root=" + this.isRoot() + ", passed=" + this.isPassed() + ", followingStatuses=" + this.getFollowingStatuses() + ")";
    }
}

