/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.nemerosa.ontrack.model.structure.BranchBuildView;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampRunView;

public class ValidationRun
implements ProjectEntity {
    private final ID id;
    @JsonView(value={ValidationRun.class, ValidationStampRunView.class})
    private final Build build;
    @JsonView(value={ValidationRun.class, Build.class})
    private final ValidationStamp validationStamp;
    private final int runOrder;
    @JsonView(value={ValidationRun.class, BranchBuildView.class, Build.class, ValidationStampRunView.class})
    private final List<ValidationRunStatus> validationRunStatuses;

    public ValidationRun add(ValidationRunStatus status) {
        ArrayList<ValidationRunStatus> statuses = new ArrayList<ValidationRunStatus>(this.validationRunStatuses);
        statuses.add(0, status);
        return new ValidationRun(this.id, this.build, this.validationStamp, this.runOrder, Collections.unmodifiableList(statuses));
    }

    @Override
    public Project getProject() {
        return this.getBuild().getProject();
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.VALIDATION_RUN;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Validation run %s#%d for %s/%s/%s", this.validationStamp.getName(), this.runOrder, this.build.getBranch().getProject().getName(), this.build.getBranch().getName(), this.build.getName());
    }

    public static ValidationRun of(Build build, ValidationStamp validationStamp, int runOrder, Signature signature, ValidationRunStatusID validationRunStatusID, String description) {
        List<ValidationRunStatus> statuses = Collections.singletonList(ValidationRunStatus.of(signature, validationRunStatusID, description));
        return ValidationRun.of(build, validationStamp, runOrder, statuses);
    }

    public static ValidationRun of(Build build, ValidationStamp validationStamp, int runOrder, List<ValidationRunStatus> statuses) {
        return new ValidationRun(ID.NONE, build, validationStamp, runOrder, statuses);
    }

    public ValidationRun withId(ID id) {
        return new ValidationRun(id, this.build, this.validationStamp, this.runOrder, this.validationRunStatuses);
    }

    public boolean isPassed() {
        return this.getLastStatus().isPassed();
    }

    public ValidationRunStatus getLastStatus() {
        return this.validationRunStatuses.get(0);
    }

    @Override
    public Signature getSignature() {
        return this.getLastStatus().getSignature();
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public Build getBuild() {
        return this.build;
    }

    public ValidationStamp getValidationStamp() {
        return this.validationStamp;
    }

    public int getRunOrder() {
        return this.runOrder;
    }

    public List<ValidationRunStatus> getValidationRunStatuses() {
        return this.validationRunStatuses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationRun)) {
            return false;
        }
        ValidationRun other = (ValidationRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        ValidationStamp this$validationStamp = this.getValidationStamp();
        ValidationStamp other$validationStamp = other.getValidationStamp();
        if (this$validationStamp == null ? other$validationStamp != null : !((Object)this$validationStamp).equals(other$validationStamp)) {
            return false;
        }
        if (this.getRunOrder() != other.getRunOrder()) {
            return false;
        }
        List<ValidationRunStatus> this$validationRunStatuses = this.getValidationRunStatuses();
        List<ValidationRunStatus> other$validationRunStatuses = other.getValidationRunStatuses();
        return !(this$validationRunStatuses == null ? other$validationRunStatuses != null : !((Object)this$validationRunStatuses).equals(other$validationRunStatuses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationRun;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        ValidationStamp $validationStamp = this.getValidationStamp();
        result = result * 59 + ($validationStamp == null ? 43 : ((Object)$validationStamp).hashCode());
        result = result * 59 + this.getRunOrder();
        List<ValidationRunStatus> $validationRunStatuses = this.getValidationRunStatuses();
        result = result * 59 + ($validationRunStatuses == null ? 43 : ((Object)$validationRunStatuses).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationRun(id=" + this.getId() + ", build=" + this.getBuild() + ", validationStamp=" + this.getValidationStamp() + ", runOrder=" + this.getRunOrder() + ", validationRunStatuses=" + this.getValidationRunStatuses() + ")";
    }

    @ConstructorProperties(value={"id", "build", "validationStamp", "runOrder", "validationRunStatuses"})
    protected ValidationRun(ID id, Build build, ValidationStamp validationStamp, int runOrder, List<ValidationRunStatus> validationRunStatuses) {
        this.id = id;
        this.build = build;
        this.validationStamp = validationStamp;
        this.runOrder = runOrder;
        this.validationRunStatuses = validationRunStatuses;
    }
}

