/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.structure.TemplateParameterValue;

public class TemplateInstanceExecution {
    private final Function<String, String> replacementFn;
    private final Map<String, String> parameterValues;

    public String replace(String value) {
        return this.replacementFn.apply(value);
    }

    public List<TemplateParameterValue> asTemplateParameterValues() {
        return this.parameterValues.entrySet().stream().map(entry -> new TemplateParameterValue((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"replacementFn", "parameterValues"})
    public TemplateInstanceExecution(Function<String, String> replacementFn, Map<String, String> parameterValues) {
        this.replacementFn = replacementFn;
        this.parameterValues = parameterValues;
    }

    public Function<String, String> getReplacementFn() {
        return this.replacementFn;
    }

    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateInstanceExecution)) {
            return false;
        }
        TemplateInstanceExecution other = (TemplateInstanceExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Function<String, String> this$replacementFn = this.getReplacementFn();
        Function<String, String> other$replacementFn = other.getReplacementFn();
        if (this$replacementFn == null ? other$replacementFn != null : !this$replacementFn.equals(other$replacementFn)) {
            return false;
        }
        Map<String, String> this$parameterValues = this.getParameterValues();
        Map<String, String> other$parameterValues = other.getParameterValues();
        return !(this$parameterValues == null ? other$parameterValues != null : !((Object)this$parameterValues).equals(other$parameterValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateInstanceExecution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Function<String, String> $replacementFn = this.getReplacementFn();
        result = result * 59 + ($replacementFn == null ? 43 : $replacementFn.hashCode());
        Map<String, String> $parameterValues = this.getParameterValues();
        result = result * 59 + ($parameterValues == null ? 43 : ((Object)$parameterValues).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateInstanceExecution(replacementFn=" + this.getReplacementFn() + ", parameterValues=" + this.getParameterValues() + ")";
    }
}

