/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.TemplateParameterValue;

public class TemplateInstance {
    private final ID templateDefinitionId;
    private final List<TemplateParameterValue> parameterValues;

    @JsonIgnore
    public Map<String, String> getParameterMap() {
        return this.parameterValues.stream().collect(Collectors.toMap(TemplateParameterValue::getName, TemplateParameterValue::getValue));
    }

    @ConstructorProperties(value={"templateDefinitionId", "parameterValues"})
    public TemplateInstance(ID templateDefinitionId, List<TemplateParameterValue> parameterValues) {
        this.templateDefinitionId = templateDefinitionId;
        this.parameterValues = parameterValues;
    }

    public ID getTemplateDefinitionId() {
        return this.templateDefinitionId;
    }

    public List<TemplateParameterValue> getParameterValues() {
        return this.parameterValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateInstance)) {
            return false;
        }
        TemplateInstance other = (TemplateInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$templateDefinitionId = this.getTemplateDefinitionId();
        ID other$templateDefinitionId = other.getTemplateDefinitionId();
        if (this$templateDefinitionId == null ? other$templateDefinitionId != null : !((Object)this$templateDefinitionId).equals(other$templateDefinitionId)) {
            return false;
        }
        List<TemplateParameterValue> this$parameterValues = this.getParameterValues();
        List<TemplateParameterValue> other$parameterValues = other.getParameterValues();
        return !(this$parameterValues == null ? other$parameterValues != null : !((Object)this$parameterValues).equals(other$parameterValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $templateDefinitionId = this.getTemplateDefinitionId();
        result = result * 59 + ($templateDefinitionId == null ? 43 : ((Object)$templateDefinitionId).hashCode());
        List<TemplateParameterValue> $parameterValues = this.getParameterValues();
        result = result * 59 + ($parameterValues == null ? 43 : ((Object)$parameterValues).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateInstance(templateDefinitionId=" + this.getTemplateDefinitionId() + ", parameterValues=" + this.getParameterValues() + ")";
    }
}

