/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.structure.ExpressionEngine;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import net.nemerosa.ontrack.model.structure.TemplateInstanceExecution;
import net.nemerosa.ontrack.model.structure.TemplateParameter;
import net.nemerosa.ontrack.model.structure.TemplateSynchronisationAbsencePolicy;

public class TemplateDefinition {
    private final List<TemplateParameter> parameters;
    @NotNull
    private final ServiceConfiguration synchronisationSourceConfig;
    @NotNull
    private final TemplateSynchronisationAbsencePolicy absencePolicy;
    private final int interval;

    public TemplateInstanceExecution templateInstanceExecution(String sourceName, ExpressionEngine expressionEngine) {
        Map<String, String> sourceNameInput = Collections.singletonMap("sourceName", sourceName);
        Map parameterMap = Maps.transformValues((Map)Maps.uniqueIndex(this.parameters, TemplateParameter::getName), parameter -> expressionEngine.render(parameter.getExpression(), sourceNameInput));
        HashMap<String, String> inputMap = new HashMap<String, String>(sourceNameInput);
        inputMap.putAll(parameterMap);
        return new TemplateInstanceExecution(value -> expressionEngine.render((String)value, (Map<String, ?>)inputMap), parameterMap);
    }

    public void checkCompilation(ExpressionEngine expressionEngine) {
        this.templateInstanceExecution("x", expressionEngine);
    }

    @JsonIgnore
    public Form getForm() {
        Form form = Form.create();
        if (!this.parameters.isEmpty()) {
            form = form.with(((YesNo)((YesNo)YesNo.of("manual").label("Manual")).help("Do not use automatic expansion of parameters using the branch name.")).value(false));
            for (TemplateParameter parameter : this.parameters) {
                form = form.with((Field)((Text)((Text)Text.of(parameter.getName()).label(parameter.getName())).visibleIf("manual")).help(parameter.getDescription()));
            }
        }
        return form;
    }

    @ConstructorProperties(value={"parameters", "synchronisationSourceConfig", "absencePolicy", "interval"})
    public TemplateDefinition(List<TemplateParameter> parameters, ServiceConfiguration synchronisationSourceConfig, TemplateSynchronisationAbsencePolicy absencePolicy, int interval) {
        this.parameters = parameters;
        this.synchronisationSourceConfig = synchronisationSourceConfig;
        this.absencePolicy = absencePolicy;
        this.interval = interval;
    }

    public List<TemplateParameter> getParameters() {
        return this.parameters;
    }

    public ServiceConfiguration getSynchronisationSourceConfig() {
        return this.synchronisationSourceConfig;
    }

    public TemplateSynchronisationAbsencePolicy getAbsencePolicy() {
        return this.absencePolicy;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateDefinition)) {
            return false;
        }
        TemplateDefinition other = (TemplateDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TemplateParameter> this$parameters = this.getParameters();
        List<TemplateParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        ServiceConfiguration this$synchronisationSourceConfig = this.getSynchronisationSourceConfig();
        ServiceConfiguration other$synchronisationSourceConfig = other.getSynchronisationSourceConfig();
        if (this$synchronisationSourceConfig == null ? other$synchronisationSourceConfig != null : !((Object)this$synchronisationSourceConfig).equals(other$synchronisationSourceConfig)) {
            return false;
        }
        TemplateSynchronisationAbsencePolicy this$absencePolicy = this.getAbsencePolicy();
        TemplateSynchronisationAbsencePolicy other$absencePolicy = other.getAbsencePolicy();
        if (this$absencePolicy == null ? other$absencePolicy != null : !this$absencePolicy.equals(other$absencePolicy)) {
            return false;
        }
        return this.getInterval() == other.getInterval();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TemplateParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        ServiceConfiguration $synchronisationSourceConfig = this.getSynchronisationSourceConfig();
        result = result * 59 + ($synchronisationSourceConfig == null ? 43 : ((Object)$synchronisationSourceConfig).hashCode());
        TemplateSynchronisationAbsencePolicy $absencePolicy = this.getAbsencePolicy();
        result = result * 59 + ($absencePolicy == null ? 43 : $absencePolicy.hashCode());
        result = result * 59 + this.getInterval();
        return result;
    }

    public String toString() {
        return "TemplateDefinition(parameters=" + this.getParameters() + ", synchronisationSourceConfig=" + this.getSynchronisationSourceConfig() + ", absencePolicy=" + this.getAbsencePolicy() + ", interval=" + this.getInterval() + ")";
    }
}

