/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.exceptions.SyncTargetItemPresentException;
import net.nemerosa.ontrack.model.exceptions.SyncTargetItemUnknownException;
import net.nemerosa.ontrack.model.structure.SyncConfig;
import net.nemerosa.ontrack.model.structure.SyncResult;

public class SyncPolicy {
    private final TargetPresentPolicy targetPresentPolicy;
    private final UnknownTargetPolicy unknownTargetPolicy;
    public static final SyncPolicy COPY = new SyncPolicy(TargetPresentPolicy.IGNORE, UnknownTargetPolicy.IGNORE);
    public static final SyncPolicy SYNC = new SyncPolicy(TargetPresentPolicy.REPLACE, UnknownTargetPolicy.DELETE);
    public static final SyncPolicy SYNC_KEEP = new SyncPolicy(TargetPresentPolicy.REPLACE, UnknownTargetPolicy.IGNORE);

    public <T, D> SyncResult sync(SyncConfig<T, D> config) {
        SyncResult result = SyncResult.empty();
        Collection sourceItems = config.getSourceItems();
        Map targetMap = config.getTargetItems().stream().collect(Collectors.toMap(config::getItemId, Function.identity()));
        block8: for (Object sourceItem : sourceItems) {
            D itemId = config.getItemId(sourceItem);
            Object targetItem = targetMap.get(itemId);
            if (targetItem != null && config.isTargetItemPresent(targetItem)) {
                switch (this.targetPresentPolicy) {
                    case IGNORE: {
                        result.ignorePresentTarget();
                        continue block8;
                    }
                    case REPLACE: {
                        config.replaceTargetItem(sourceItem, targetItem);
                        result.replacePresentTarget();
                        continue block8;
                    }
                }
                throw new SyncTargetItemPresentException(config.getItemType(), itemId);
            }
            config.createTargetItem(sourceItem);
            result.create();
        }
        targetMap = config.getTargetItems().stream().collect(Collectors.toMap(config::getItemId, Function.identity()));
        HashSet<Object> targetIds = new HashSet<Object>(targetMap.keySet());
        Collection sourceIds = sourceItems.stream().map(config::getItemId).collect(Collectors.toList());
        targetIds.removeAll(sourceIds);
        int unknownTargetNumber = targetIds.size();
        if (unknownTargetNumber > 0) {
            switch (this.unknownTargetPolicy) {
                case IGNORE: {
                    result.setUnknownTargetIgnored(unknownTargetNumber);
                    break;
                }
                case DELETE: {
                    for (Object e : targetIds) {
                        Object targetItem = targetMap.get(e);
                        config.deleteTargetItem(targetItem);
                    }
                    result.setUnknownTargetDeleted(unknownTargetNumber);
                    break;
                }
                default: {
                    throw new SyncTargetItemUnknownException(config.getItemType(), targetIds);
                }
            }
        }
        return result;
    }

    @ConstructorProperties(value={"targetPresentPolicy", "unknownTargetPolicy"})
    public SyncPolicy(TargetPresentPolicy targetPresentPolicy, UnknownTargetPolicy unknownTargetPolicy) {
        this.targetPresentPolicy = targetPresentPolicy;
        this.unknownTargetPolicy = unknownTargetPolicy;
    }

    public TargetPresentPolicy getTargetPresentPolicy() {
        return this.targetPresentPolicy;
    }

    public UnknownTargetPolicy getUnknownTargetPolicy() {
        return this.unknownTargetPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SyncPolicy)) {
            return false;
        }
        SyncPolicy other = (SyncPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TargetPresentPolicy this$targetPresentPolicy = this.getTargetPresentPolicy();
        TargetPresentPolicy other$targetPresentPolicy = other.getTargetPresentPolicy();
        if (this$targetPresentPolicy == null ? other$targetPresentPolicy != null : !((Object)((Object)this$targetPresentPolicy)).equals((Object)other$targetPresentPolicy)) {
            return false;
        }
        UnknownTargetPolicy this$unknownTargetPolicy = this.getUnknownTargetPolicy();
        UnknownTargetPolicy other$unknownTargetPolicy = other.getUnknownTargetPolicy();
        return !(this$unknownTargetPolicy == null ? other$unknownTargetPolicy != null : !((Object)((Object)this$unknownTargetPolicy)).equals((Object)other$unknownTargetPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SyncPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TargetPresentPolicy $targetPresentPolicy = this.getTargetPresentPolicy();
        result = result * 59 + ($targetPresentPolicy == null ? 43 : ((Object)((Object)$targetPresentPolicy)).hashCode());
        UnknownTargetPolicy $unknownTargetPolicy = this.getUnknownTargetPolicy();
        result = result * 59 + ($unknownTargetPolicy == null ? 43 : ((Object)((Object)$unknownTargetPolicy)).hashCode());
        return result;
    }

    public String toString() {
        return "SyncPolicy(targetPresentPolicy=" + (Object)((Object)this.getTargetPresentPolicy()) + ", unknownTargetPolicy=" + (Object)((Object)this.getUnknownTargetPolicy()) + ")";
    }

    public static enum UnknownTargetPolicy {
        IGNORE,
        DELETE,
        ERROR;

    }

    public static enum TargetPresentPolicy {
        IGNORE,
        REPLACE,
        ERROR;

    }
}

