/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.nemerosa.ontrack.common.Document;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildLinkForm;
import net.nemerosa.ontrack.model.structure.BuildSearchForm;
import net.nemerosa.ontrack.model.structure.BuildSortDirection;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.PredefinedPromotionLevel;
import net.nemerosa.ontrack.model.structure.PredefinedValidationStamp;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.ProjectStatusView;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.PromotionRunView;
import net.nemerosa.ontrack.model.structure.Reordering;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatus;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampRunView;

public interface StructureService {
    public List<ProjectStatusView> getProjectStatusViews();

    public List<ProjectStatusView> getProjectStatusViewsForFavourites();

    public List<Project> getProjectFavourites();

    public Project newProject(Project var1);

    public List<Project> getProjectList();

    public Project getProject(ID var1);

    public void saveProject(Project var1);

    public Ack deleteProject(ID var1);

    public Branch getBranch(ID var1);

    public List<Branch> getBranchesForProject(ID var1);

    public Branch newBranch(Branch var1);

    public List<BranchStatusView> getBranchStatusViews(ID var1);

    public BranchStatusView getBranchStatusView(Branch var1);

    public void saveBranch(Branch var1);

    public Ack deleteBranch(ID var1);

    public Build newBuild(Build var1);

    public Build saveBuild(Build var1);

    public Build getBuild(ID var1);

    public Optional<Build> findBuildByName(String var1, String var2, String var3);

    public BranchStatusView getEarliestPromotionsAfterBuild(Build var1);

    public Optional<Build> findBuildAfterUsingNumericForm(ID var1, String var2);

    public BuildView getBuildView(Build var1, boolean var2);

    public Build getLastBuildForBranch(Branch var1);

    public int getBuildCount(Branch var1);

    public Ack deleteBuild(ID var1);

    public Optional<Build> getPreviousBuild(ID var1);

    public Optional<Build> getNextBuild(ID var1);

    public void addBuildLink(Build var1, Build var2);

    public void deleteBuildLink(Build var1, Build var2);

    public List<Build> getBuildLinksFrom(Build var1);

    public List<Build> getBuildLinksTo(Build var1);

    public List<Build> searchBuildsLinkedTo(String var1, String var2);

    public void editBuildLinks(Build var1, BuildLinkForm var2);

    public boolean isLinkedFrom(Build var1, String var2, String var3);

    public boolean isLinkedTo(Build var1, String var2, String var3);

    public Optional<Build> findBuild(ID var1, Predicate<Build> var2, BuildSortDirection var3);

    public Optional<Build> getLastBuild(ID var1);

    public List<Build> buildSearch(ID var1, BuildSearchForm var2);

    public List<ValidationStampRunView> getValidationStampRunViewsForBuild(Build var1);

    public List<PromotionLevel> getPromotionLevelListForBranch(ID var1);

    public PromotionLevel newPromotionLevel(PromotionLevel var1);

    public PromotionLevel getPromotionLevel(ID var1);

    public Document getPromotionLevelImage(ID var1);

    public void setPromotionLevelImage(ID var1, Document var2);

    public void savePromotionLevel(PromotionLevel var1);

    public Ack deletePromotionLevel(ID var1);

    public void reorderPromotionLevels(ID var1, Reordering var2);

    public PromotionLevel newPromotionLevelFromPredefined(Branch var1, PredefinedPromotionLevel var2);

    public PromotionLevel getOrCreatePromotionLevel(Branch var1, Integer var2, String var3);

    public PromotionRun newPromotionRun(PromotionRun var1);

    public PromotionRun getPromotionRun(ID var1);

    public Optional<PromotionLevel> findPromotionLevelByName(String var1, String var2, String var3);

    public List<PromotionRun> getPromotionRunsForBuild(ID var1);

    public List<PromotionRun> getLastPromotionRunsForBuild(ID var1);

    public Optional<PromotionRun> getLastPromotionRunForBuildAndPromotionLevel(Build var1, PromotionLevel var2);

    public List<PromotionRun> getPromotionRunsForBuildAndPromotionLevel(Build var1, PromotionLevel var2);

    public PromotionRun getLastPromotionRunForPromotionLevel(PromotionLevel var1);

    public PromotionRunView getPromotionRunView(PromotionLevel var1);

    public Ack deletePromotionRun(ID var1);

    public Optional<PromotionRun> getEarliestPromotionRunAfterBuild(PromotionLevel var1, Build var2);

    public List<PromotionRun> getPromotionRunsForPromotionLevel(ID var1);

    public List<ValidationStamp> getValidationStampListForBranch(ID var1);

    public ValidationStamp newValidationStamp(ValidationStamp var1);

    public ValidationStamp getValidationStamp(ID var1);

    public Optional<ValidationStamp> findValidationStampByName(String var1, String var2, String var3);

    public Document getValidationStampImage(ID var1);

    public void setValidationStampImage(ID var1, Document var2);

    public void saveValidationStamp(ValidationStamp var1);

    public Ack deleteValidationStamp(ID var1);

    public void reorderValidationStamps(ID var1, Reordering var2);

    public ValidationStamp newValidationStampFromPredefined(Branch var1, PredefinedValidationStamp var2);

    public ValidationStamp getOrCreateValidationStamp(Branch var1, Integer var2, String var3);

    public Ack bulkUpdateValidationStamps(ID var1);

    public ValidationRun newValidationRun(ValidationRun var1);

    public ValidationRun getValidationRun(ID var1);

    public List<ValidationRun> getValidationRunsForBuild(ID var1);

    public List<ValidationRun> getValidationRunsForBuildAndValidationStamp(ID var1, ID var2);

    public List<ValidationRun> getValidationRunsForValidationStamp(ID var1, int var2, int var3);

    public ValidationRun newValidationRunStatus(ValidationRun var1, ValidationRunStatus var2);

    public Optional<Project> findProjectByName(String var1);

    public Optional<Branch> findBranchByName(String var1, String var2);

    default public BiFunction<ProjectEntityType, ID, ProjectEntity> entityLoader() {
        return (entityType, id) -> entityType.getEntityFn(this).apply((ID)id);
    }
}

