/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.structure.Signature;
import org.apache.commons.lang3.StringUtils;

public class SignatureRequest {
    private final LocalDateTime time;
    private final String user;

    public static SignatureRequest of(Signature signature) {
        return new SignatureRequest(signature.getTime(), signature.getUser().getName());
    }

    public static Form form() {
        return Form.create().with((Field)((Text)Text.of("user").label("User name")).optional()).with((Field)((Text)Text.of("time").label("Date/time")).optional());
    }

    public Form asForm() {
        return SignatureRequest.form().fill("user", this.user).fill("time", this.time);
    }

    public Signature getSignature(Signature signature) {
        return Signature.of(StringUtils.isNotBlank((CharSequence)this.user) ? this.user : signature.getUser().getName()).withTime(this.time != null ? this.time : signature.getTime());
    }

    @ConstructorProperties(value={"time", "user"})
    public SignatureRequest(LocalDateTime time, String user) {
        this.time = time;
        this.user = user;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignatureRequest)) {
            return false;
        }
        SignatureRequest other = (SignatureRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignatureRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "SignatureRequest(time=" + this.getTime() + ", user=" + this.getUser() + ")";
    }
}

