/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.model.structure.User;

public class Signature {
    private final LocalDateTime time;
    private final User user;

    public static Signature of(String name) {
        return Signature.of(Time.now(), name);
    }

    public static Signature of(LocalDateTime dateTime, String name) {
        return new Signature(dateTime, User.of(name));
    }

    public static Signature none() {
        return new Signature(Time.now(), User.anonymous());
    }

    public Signature withTime(LocalDateTime dateTime) {
        return new Signature(dateTime, this.user);
    }

    @ConstructorProperties(value={"time", "user"})
    public Signature(LocalDateTime time, User user) {
        this.time = time;
        this.user = user;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Signature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "Signature(time=" + this.getTime() + ", user=" + this.getUser() + ")";
    }
}

