/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Replacement {
    private final String regex;
    private final String replacement;

    public String replace(String value) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.regex) && StringUtils.isNotBlank((CharSequence)this.replacement)) {
            Matcher m = Pattern.compile(this.regex).matcher(value);
            StringBuffer s = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(s, this.replacement);
            }
            m.appendTail(s);
            return s.toString();
        }
        return value;
    }

    public static Function<String, String> replacementFn(List<Replacement> replacements) {
        return value -> {
            String transformedValue = value;
            for (Replacement replacement : replacements) {
                transformedValue = replacement.replace(transformedValue);
            }
            return transformedValue;
        };
    }

    @ConstructorProperties(value={"regex", "replacement"})
    public Replacement(String regex, String replacement) {
        this.regex = regex;
        this.replacement = replacement;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Replacement)) {
            return false;
        }
        Replacement other = (Replacement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Replacement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        return result;
    }

    public String toString() {
        return "Replacement(regex=" + this.getRegex() + ", replacement=" + this.getReplacement() + ")";
    }
}

