/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.model.extension.Extension;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Property;
import org.apache.commons.lang3.StringUtils;

public interface PropertyType<T>
extends Extension {
    public String getName();

    public String getDescription();

    public Set<ProjectEntityType> getSupportedEntityTypes();

    public boolean canEdit(ProjectEntity var1, SecurityService var2);

    public boolean canView(ProjectEntity var1, SecurityService var2);

    public Form getEditionForm(ProjectEntity var1, T var2);

    public Property<T> of(T var1);

    public JsonNode forStorage(T var1);

    public T fromClient(JsonNode var1);

    public T fromStorage(JsonNode var1);

    default public Property<T> of(JsonNode node) {
        return this.of(this.fromStorage(node));
    }

    public String getSearchKey(T var1);

    public T replaceValue(T var1, Function<String, String> var2);

    default public boolean containsValue(T value, String propertyValue) {
        return StringUtils.containsIgnoreCase((CharSequence)this.getSearchKey(value), (CharSequence)propertyValue);
    }

    default public String getTypeName() {
        return this.getClass().getName();
    }

    default public T copy(ProjectEntity sourceEntity, T value, ProjectEntity targetEntity, Function<String, String> replacementFn) {
        return this.replaceValue(value, replacementFn);
    }

    default public void onPropertyChanged(ProjectEntity entity, T value) {
    }

    default public void onPropertyDeleted(ProjectEntity entity, T oldValue) {
    }
}

