/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyType;

public interface PropertyService {
    public List<PropertyType<?>> getPropertyTypes();

    public <T> PropertyType<T> getPropertyTypeByName(String var1);

    public List<Property<?>> getProperties(ProjectEntity var1);

    public Form getPropertyEditionForm(ProjectEntity var1, String var2);

    public <T> Property<T> getProperty(ProjectEntity var1, String var2);

    public <T> Property<T> getProperty(ProjectEntity var1, Class<? extends PropertyType<T>> var2);

    public Ack editProperty(ProjectEntity var1, String var2, JsonNode var3);

    public <T> Ack editProperty(ProjectEntity var1, Class<? extends PropertyType<T>> var2, T var3);

    public Ack deleteProperty(ProjectEntity var1, String var2);

    default public <T> Ack deleteProperty(ProjectEntity entity, Class<? extends PropertyType<T>> propertyType) {
        return this.deleteProperty(entity, propertyType.getName());
    }

    public <T> Collection<ProjectEntity> searchWithPropertyValue(Class<? extends PropertyType<T>> var1, BiFunction<ProjectEntityType, ID, ProjectEntity> var2, Predicate<T> var3);

    default public <T> boolean hasProperty(ProjectEntity entity, Class<? extends PropertyType<T>> propertyTypeClass) {
        return !this.getProperty(entity, propertyTypeClass).isEmpty();
    }

    public <T> void copyProperty(ProjectEntity var1, Property<T> var2, ProjectEntity var3, Function<String, String> var4);
}

