/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Optional;
import net.nemerosa.ontrack.model.structure.PropertyType;
import net.nemerosa.ontrack.model.structure.PropertyTypeDescriptor;

public class Property<T> {
    @JsonIgnore
    private final PropertyType<T> type;
    private final T value;
    private final boolean editable;

    public PropertyTypeDescriptor getTypeDescriptor() {
        return PropertyTypeDescriptor.of(this.type);
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Optional<T> option() {
        return Optional.ofNullable(this.value);
    }

    public Property<T> editable(boolean editable) {
        return new Property<T>(this.type, this.value, editable);
    }

    public static <T> Property<T> empty(PropertyType<T> type) {
        return new Property<Object>(type, null, false);
    }

    public static <T> Property<T> of(PropertyType<T> type, T value) {
        return new Property<T>(type, value, false);
    }

    public boolean containsValue(String propertyValue) {
        return this.value != null && this.type.containsValue(this.value, propertyValue);
    }

    public PropertyType<T> getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PropertyType<T> this$type = this.getType();
        PropertyType<T> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isEditable() == other.isEditable();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PropertyType<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isEditable() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Property(type=" + this.getType() + ", value=" + this.getValue() + ", editable=" + this.isEditable() + ")";
    }

    @ConstructorProperties(value={"type", "value", "editable"})
    protected Property(PropertyType<T> type, T value, boolean editable) {
        this.type = type;
        this.value = value;
        this.editable = editable;
    }
}

