/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.buildfilter.BuildDiff;
import net.nemerosa.ontrack.model.structure.BranchBuildView;
import net.nemerosa.ontrack.model.structure.BranchStatusView;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.ProjectStatusView;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRunView;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.Signature;

@JsonPropertyOrder(alphabetic=true)
public class PromotionRun
implements ProjectEntity {
    private final ID id;
    @JsonView(value={ProjectStatusView.class, BranchStatusView.class, PromotionView.class, PromotionRun.class, Build.class, PromotionRunView.class})
    private final Build build;
    @JsonView(value={Build.class, PromotionRun.class, BranchBuildView.class, BuildDiff.class, BuildView.class, Decoration.class})
    private final PromotionLevel promotionLevel;
    private final Signature signature;
    private final String description;

    public static PromotionRun of(Build build, PromotionLevel promotionLevel, Signature signature, String description) {
        return new PromotionRun(ID.NONE, build, promotionLevel, signature, description);
    }

    @Override
    public Project getProject() {
        return this.getBuild().getProject();
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.PROMOTION_RUN;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Promotion run %s/%s/%s/%s", this.build.getBranch().getProject().getName(), this.build.getBranch().getName(), this.build.getName(), this.promotionLevel.getName());
    }

    public PromotionRun withId(ID id) {
        return new PromotionRun(id, this.build, this.promotionLevel, this.signature, this.description);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public Build getBuild() {
        return this.build;
    }

    public PromotionLevel getPromotionLevel() {
        return this.promotionLevel;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromotionRun)) {
            return false;
        }
        PromotionRun other = (PromotionRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Build this$build = this.getBuild();
        Build other$build = other.getBuild();
        if (this$build == null ? other$build != null : !((Object)this$build).equals(other$build)) {
            return false;
        }
        PromotionLevel this$promotionLevel = this.getPromotionLevel();
        PromotionLevel other$promotionLevel = other.getPromotionLevel();
        if (this$promotionLevel == null ? other$promotionLevel != null : !((Object)this$promotionLevel).equals(other$promotionLevel)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromotionRun;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Build $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : ((Object)$build).hashCode());
        PromotionLevel $promotionLevel = this.getPromotionLevel();
        result = result * 59 + ($promotionLevel == null ? 43 : ((Object)$promotionLevel).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "PromotionRun(id=" + this.getId() + ", build=" + this.getBuild() + ", promotionLevel=" + this.getPromotionLevel() + ", signature=" + this.getSignature() + ", description=" + this.getDescription() + ")";
    }

    @ConstructorProperties(value={"id", "build", "promotionLevel", "signature", "description"})
    protected PromotionRun(ID id, Build build, PromotionLevel promotionLevel, Signature signature, String description) {
        this.id = id;
        this.build = build;
        this.promotionLevel = promotionLevel;
        this.signature = signature;
        this.description = description;
    }
}

