/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionRunView;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.Signature;

@JsonPropertyOrder(value={"id", "name", "description", "branch", "image"})
public class PromotionLevel
implements ProjectEntity {
    private final ID id;
    private final String name;
    private final String description;
    @JsonView(value={PromotionLevel.class, PromotionView.class, PromotionRunView.class})
    private final Branch branch;
    private final Boolean image;
    private final Signature signature;

    public static PromotionLevel of(Branch branch, NameDescription nameDescription) {
        Entity.isEntityDefined(branch, "Branch must be defined");
        Entity.isEntityDefined(branch.getProject(), "Project must be defined");
        return new PromotionLevel(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), branch, false, Signature.none());
    }

    @Override
    public Project getProject() {
        return this.getBranch().getProject();
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.PROMOTION_LEVEL;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Promotion level %s/%s/%s", this.branch.getProject().getName(), this.branch.getName(), this.name);
    }

    public PromotionLevel withId(ID id) {
        return new PromotionLevel(id, this.name, this.description, this.branch, this.image, this.signature);
    }

    public PromotionLevel withImage(boolean image) {
        return new PromotionLevel(this.id, this.name, this.description, this.branch, image, this.signature);
    }

    public static Form form() {
        return Form.nameAndDescription();
    }

    public Form asForm() {
        return PromotionLevel.form().fill("name", this.name).fill("description", this.description);
    }

    public PromotionLevel update(NameDescription nameDescription) {
        return new PromotionLevel(this.id, nameDescription.getName(), nameDescription.getDescription(), this.branch, this.image, this.signature);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Boolean getImage() {
        return this.image;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PromotionLevel)) {
            return false;
        }
        PromotionLevel other = (PromotionLevel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Branch this$branch = this.getBranch();
        Branch other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !((Object)this$branch).equals(other$branch)) {
            return false;
        }
        Boolean this$image = this.getImage();
        Boolean other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PromotionLevel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Branch $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : ((Object)$branch).hashCode());
        Boolean $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "PromotionLevel(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", branch=" + this.getBranch() + ", image=" + this.getImage() + ", signature=" + this.getSignature() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "branch", "image", "signature"})
    protected PromotionLevel(ID id, String name, String description, Branch branch, Boolean image, Signature signature) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.branch = branch;
        this.image = image;
        this.signature = signature;
    }

    public PromotionLevel withDescription(String description) {
        return this.description == description ? this : new PromotionLevel(this.id, this.name, description, this.branch, this.image, this.signature);
    }

    public PromotionLevel withSignature(Signature signature) {
        return this.signature == signature ? this : new PromotionLevel(this.id, this.name, this.description, this.branch, this.image, signature);
    }
}

