/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Signature;

public class Project
implements ProjectEntity {
    private final ID id;
    private final String name;
    private final String description;
    private final boolean disabled;
    private final Signature signature;

    public Project withId(ID id) {
        return new Project(id, this.name, this.description, this.disabled, this.signature);
    }

    public static Project of(NameDescriptionState nameDescription) {
        return new Project(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), nameDescription.isDisabled(), Signature.none());
    }

    public static Project of(NameDescription nameDescription) {
        return new Project(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), false, Signature.none());
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.PROJECT;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Project %s", this.name);
    }

    public static Form form() {
        return Form.nameAndDescription().with((Field)((YesNo)YesNo.of("disabled").label("Disabled")).help("Check if the project must be disabled."));
    }

    public Project update(NameDescriptionState form) {
        return Project.of(form).withId(this.id).withDisabled(form.isDisabled());
    }

    public Form asForm() {
        return Project.form().name(this.name).description(this.description).fill("disabled", this.disabled);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "Project(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", disabled=" + this.isDisabled() + ", signature=" + this.getSignature() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "disabled", "signature"})
    public Project(ID id, String name, String description, boolean disabled, Signature signature) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.disabled = disabled;
        this.signature = signature;
    }

    public Project withDisabled(boolean disabled) {
        return this.disabled == disabled ? this : new Project(this.id, this.name, this.description, disabled, this.signature);
    }

    public Project withSignature(Signature signature) {
        return this.signature == signature ? this : new Project(this.id, this.name, this.description, this.disabled, signature);
    }
}

