/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;

@JsonPropertyOrder(value={"id", "name", "description", "image"})
public class PredefinedPromotionLevel
implements Entity {
    private final ID id;
    private final String name;
    private final String description;
    private final Boolean image;

    public static PredefinedPromotionLevel of(NameDescription nameDescription) {
        return new PredefinedPromotionLevel(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), false);
    }

    public PredefinedPromotionLevel withId(ID id) {
        return new PredefinedPromotionLevel(id, this.name, this.description, this.image);
    }

    public PredefinedPromotionLevel withImage(boolean image) {
        return new PredefinedPromotionLevel(this.id, this.name, this.description, image);
    }

    public static Form form() {
        return Form.nameAndDescription();
    }

    public Form asForm() {
        return PredefinedPromotionLevel.form().fill("name", this.name).fill("description", this.description);
    }

    public PredefinedPromotionLevel update(NameDescription nameDescription) {
        return new PredefinedPromotionLevel(this.id, nameDescription.getName(), nameDescription.getDescription(), this.image);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getImage() {
        return this.image;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PredefinedPromotionLevel)) {
            return false;
        }
        PredefinedPromotionLevel other = (PredefinedPromotionLevel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Boolean this$image = this.getImage();
        Boolean other$image = other.getImage();
        return !(this$image == null ? other$image != null : !((Object)this$image).equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PredefinedPromotionLevel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Boolean $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        return result;
    }

    public String toString() {
        return "PredefinedPromotionLevel(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", image=" + this.getImage() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "image"})
    protected PredefinedPromotionLevel(ID id, String name, String description, Boolean image) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.image = image;
    }

    public PredefinedPromotionLevel withDescription(String description) {
        return this.description == description ? this : new PredefinedPromotionLevel(this.id, this.name, description, this.image);
    }
}

