/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import org.apache.commons.lang3.StringUtils;

public class NameDescription {
    public static final String NAME = "[A-Za-z0-9\\.\\-_]+";
    public static final String NAME_MESSAGE_SUFFIX = "can only have letters, digits, dots (.), dashes (-) or underscores (_).";
    @NotNull(message="The name is required.")
    @Pattern(regexp="[A-Za-z0-9\\.\\-_]+", message="The name can only have letters, digits, dots (.), dashes (-) or underscores (_).")
    private final String name;
    private final String description;

    public static NameDescription nd(String name, String description) {
        return new NameDescription(name, description);
    }

    public NameDescriptionState asState() {
        return this.asState(false);
    }

    public NameDescriptionState asState(boolean disabled) {
        return new NameDescriptionState(this.name, this.description, disabled);
    }

    public static String escapeName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Blank or null is not a valid name.");
        }
        if (java.util.regex.Pattern.matches(NAME, name)) {
            return name;
        }
        return name.replaceAll("[^A-Za-z0-9\\.\\-_]", "-");
    }

    @ConstructorProperties(value={"name", "description"})
    public NameDescription(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NameDescription)) {
            return false;
        }
        NameDescription other = (NameDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NameDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "NameDescription(name=" + this.getName() + ", description=" + this.getDescription() + ")";
    }
}

