/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import net.nemerosa.ontrack.model.support.IDJsonSerializer;
import org.apache.commons.lang3.Validate;

@JsonSerialize(using=IDJsonSerializer.class)
public final class ID
implements Serializable {
    public static ID NONE = new ID(0);
    private final int value;

    public static ID of(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"ID value must be greater than zero.", (Object[])new Object[0]);
        return new ID(value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int get() {
        return this.value;
    }

    public boolean isSet() {
        return this.value > 0;
    }

    public static boolean isDefined(ID id) {
        return id != null && id.isSet();
    }

    public <T> Optional<T> ifSet(Function<Integer, T> fn) {
        if (this.isSet()) {
            return Optional.ofNullable(fn.apply(this.value));
        }
        return Optional.empty();
    }

    public int getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ID)) {
            return false;
        }
        ID other = (ID)o;
        return this.getValue() == other.getValue();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        return result;
    }

    private ID(int value) {
        this.value = value;
    }
}

