/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.structure.Decorator;
import org.apache.commons.lang3.Validate;

public class Decoration<T> {
    @JsonIgnore
    private final Decorator<T> decorator;
    private final T data;
    private final String error;

    public static <T> Decoration<T> of(Decorator<T> decorator, T data) {
        Validate.notNull(decorator, (String)"The decorator is required", (Object[])new Object[0]);
        Validate.notNull(data, (String)"The decoration data is required", (Object[])new Object[0]);
        return new Decoration<T>(decorator, data, null);
    }

    public static <T> Decoration<T> error(Decorator<T> decorator, String error) {
        Validate.notNull(decorator, (String)"The decorator is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)error, (String)"The decoration error is required", (Object[])new Object[0]);
        return new Decoration<Object>(decorator, null, error);
    }

    public String getDecorationType() {
        return this.decorator.getClass().getName();
    }

    public ExtensionFeatureDescription getFeature() {
        return this.decorator.getFeature().getFeatureDescription();
    }

    public Decorator<T> getDecorator() {
        return this.decorator;
    }

    public T getData() {
        return this.data;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Decoration)) {
            return false;
        }
        Decoration other = (Decoration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Decorator<T> this$decorator = this.getDecorator();
        Decorator<T> other$decorator = other.getDecorator();
        if (this$decorator == null ? other$decorator != null : !this$decorator.equals(other$decorator)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Decoration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Decorator<T> $decorator = this.getDecorator();
        result = result * 59 + ($decorator == null ? 43 : $decorator.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "Decoration(decorator=" + this.getDecorator() + ", data=" + this.getData() + ", error=" + this.getError() + ")";
    }

    @ConstructorProperties(value={"decorator", "data", "error"})
    protected Decoration(Decorator<T> decorator, T data, String error) {
        this.decorator = decorator;
        this.data = data;
        this.error = error;
    }
}

