/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PropertyCreationRequest;

public class BuildRequest {
    @NotNull(message="The build name is required.")
    @Pattern(regexp="[A-Za-z0-9\\.\\-_]+", message="The build name can only have letters, digits, dots (.), dashes (-) or underscores (_).")
    private final String name;
    private final String description;
    private final List<PropertyCreationRequest> properties;

    @ConstructorProperties(value={"name", "description", "properties"})
    public BuildRequest(String name, String description, List<PropertyCreationRequest> properties) {
        this.name = name;
        this.description = description;
        this.properties = properties != null ? properties : Collections.emptyList();
    }

    public NameDescription asNameDescription() {
        return new NameDescription(this.name, this.description);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PropertyCreationRequest> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildRequest)) {
            return false;
        }
        BuildRequest other = (BuildRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<PropertyCreationRequest> this$properties = this.getProperties();
        List<PropertyCreationRequest> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<PropertyCreationRequest> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "BuildRequest(name=" + this.getName() + ", description=" + this.getDescription() + ", properties=" + this.getProperties() + ")";
    }
}

