/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.buildfilter.BuildDiff;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRun;

public class Build
implements ProjectEntity {
    private final ID id;
    private final String name;
    private final String description;
    private final Signature signature;
    @JsonView(value={Build.class, BuildView.class, PromotionRun.class, ValidationRun.class, BuildDiff.class})
    private final Branch branch;

    public static Build of(Branch branch, NameDescription nameDescription, Signature signature) {
        return new Build(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), signature, branch);
    }

    @Override
    public Project getProject() {
        return this.getBranch().getProject();
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.BUILD;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Build %s/%s/%s", this.branch.getProject().getName(), this.branch.getName(), this.name);
    }

    public Build withId(ID id) {
        return new Build(id, this.name, this.description, this.signature, this.branch);
    }

    public static Form form() {
        return Form.nameAndDescription();
    }

    public Form asForm() {
        return Build.form().fill("name", this.name).fill("description", this.description);
    }

    public Build update(NameDescription nameDescription) {
        return new Build(this.id, nameDescription.getName(), nameDescription.getDescription(), this.signature, this.branch);
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Build)) {
            return false;
        }
        Build other = (Build)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        Branch this$branch = this.getBranch();
        Branch other$branch = other.getBranch();
        return !(this$branch == null ? other$branch != null : !((Object)this$branch).equals(other$branch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Build;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        Branch $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : ((Object)$branch).hashCode());
        return result;
    }

    public String toString() {
        return "Build(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", signature=" + this.getSignature() + ", branch=" + this.getBranch() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "signature", "branch"})
    public Build(ID id, String name, String description, Signature signature, Branch branch) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.signature = signature;
        this.branch = branch;
    }

    public Build withSignature(Signature signature) {
        return this.signature == signature ? this : new Build(this.id, this.name, this.description, signature, this.branch);
    }
}

