/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.structure.BranchTemplateSyncType;

public class BranchTemplateSyncResult {
    private final String branchName;
    private final BranchTemplateSyncType type;
    private final String description;
    private String sourceName;
    private String otherTemplateName;

    protected static BranchTemplateSyncResult of(String name, BranchTemplateSyncType type, String sourceName, String description) {
        return new BranchTemplateSyncResult(name, type, description, sourceName, "");
    }

    public static BranchTemplateSyncResult ignored(String name) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.IGNORED, "", "Branch has not been taken into account.");
    }

    public static BranchTemplateSyncResult deleted(String name) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.DELETED, "", "Branch has been deleted.");
    }

    public static BranchTemplateSyncResult disabled(String name) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.DISABLED, "", "Branch has been disabled.");
    }

    public static BranchTemplateSyncResult existingClassic(String name, String sourceName) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.EXISTING_CLASSIC, sourceName, "Branch already exists.");
    }

    public static BranchTemplateSyncResult existingDefinition(String name, String sourceName) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.EXISTING_DEFINITION, sourceName, "Branch is a template definition.");
    }

    public static BranchTemplateSyncResult existingInstanceFromOther(String name, String sourceName, String otherTemplateName) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.EXISTING_INSTANCE_FROM_OTHER, sourceName, "Branch is an instance for another template.").withOtherTemplateName(otherTemplateName);
    }

    public static BranchTemplateSyncResult updated(String name, String sourceName) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.UPDATED, sourceName, "Branch has been updated.");
    }

    public static BranchTemplateSyncResult created(String name, String sourceName) {
        return BranchTemplateSyncResult.of(name, BranchTemplateSyncType.CREATED, sourceName, "Branch has been created.");
    }

    public String getBranchName() {
        return this.branchName;
    }

    public BranchTemplateSyncType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getOtherTemplateName() {
        return this.otherTemplateName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setOtherTemplateName(String otherTemplateName) {
        this.otherTemplateName = otherTemplateName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BranchTemplateSyncResult)) {
            return false;
        }
        BranchTemplateSyncResult other = (BranchTemplateSyncResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$branchName = this.getBranchName();
        String other$branchName = other.getBranchName();
        if (this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName)) {
            return false;
        }
        BranchTemplateSyncType this$type = this.getType();
        BranchTemplateSyncType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        String this$otherTemplateName = this.getOtherTemplateName();
        String other$otherTemplateName = other.getOtherTemplateName();
        return !(this$otherTemplateName == null ? other$otherTemplateName != null : !this$otherTemplateName.equals(other$otherTemplateName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BranchTemplateSyncResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $branchName = this.getBranchName();
        result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
        BranchTemplateSyncType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        String $otherTemplateName = this.getOtherTemplateName();
        result = result * 59 + ($otherTemplateName == null ? 43 : $otherTemplateName.hashCode());
        return result;
    }

    public String toString() {
        return "BranchTemplateSyncResult(branchName=" + this.getBranchName() + ", type=" + (Object)((Object)this.getType()) + ", description=" + this.getDescription() + ", sourceName=" + this.getSourceName() + ", otherTemplateName=" + this.getOtherTemplateName() + ")";
    }

    @ConstructorProperties(value={"branchName", "type", "description", "sourceName", "otherTemplateName"})
    protected BranchTemplateSyncResult(String branchName, BranchTemplateSyncType type, String description, String sourceName, String otherTemplateName) {
        this.branchName = branchName;
        this.type = type;
        this.description = description;
        this.sourceName = sourceName;
        this.otherTemplateName = otherTemplateName;
    }

    private BranchTemplateSyncResult withOtherTemplateName(String otherTemplateName) {
        return this.otherTemplateName == otherTemplateName ? this : new BranchTemplateSyncResult(this.branchName, this.type, this.description, this.sourceName, otherTemplateName);
    }
}

