/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import java.beans.ConstructorProperties;
import java.util.List;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.View;

public class BranchStatusView
implements View {
    private final Branch branch;
    private final List<Decoration<?>> decorations;
    private final Build latestBuild;
    private final List<PromotionView> promotions;

    public PromotionView getLastPromotionView() {
        if (!this.promotions.isEmpty()) {
            PromotionView promotionView = null;
            for (int i = this.promotions.size() - 1; i >= 0; --i) {
                PromotionView candidate = this.promotions.get(i);
                if (candidate.getPromotionRun() == null) continue;
                promotionView = candidate;
                break;
            }
            return promotionView;
        }
        return null;
    }

    @ConstructorProperties(value={"branch", "decorations", "latestBuild", "promotions"})
    public BranchStatusView(Branch branch, List<Decoration<?>> decorations, Build latestBuild, List<PromotionView> promotions) {
        this.branch = branch;
        this.decorations = decorations;
        this.latestBuild = latestBuild;
        this.promotions = promotions;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public List<Decoration<?>> getDecorations() {
        return this.decorations;
    }

    public Build getLatestBuild() {
        return this.latestBuild;
    }

    public List<PromotionView> getPromotions() {
        return this.promotions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BranchStatusView)) {
            return false;
        }
        BranchStatusView other = (BranchStatusView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Branch this$branch = this.getBranch();
        Branch other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !((Object)this$branch).equals(other$branch)) {
            return false;
        }
        List<Decoration<?>> this$decorations = this.getDecorations();
        List<Decoration<?>> other$decorations = other.getDecorations();
        if (this$decorations == null ? other$decorations != null : !((Object)this$decorations).equals(other$decorations)) {
            return false;
        }
        Build this$latestBuild = this.getLatestBuild();
        Build other$latestBuild = other.getLatestBuild();
        if (this$latestBuild == null ? other$latestBuild != null : !((Object)this$latestBuild).equals(other$latestBuild)) {
            return false;
        }
        List<PromotionView> this$promotions = this.getPromotions();
        List<PromotionView> other$promotions = other.getPromotions();
        return !(this$promotions == null ? other$promotions != null : !((Object)this$promotions).equals(other$promotions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BranchStatusView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Branch $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : ((Object)$branch).hashCode());
        List<Decoration<?>> $decorations = this.getDecorations();
        result = result * 59 + ($decorations == null ? 43 : ((Object)$decorations).hashCode());
        Build $latestBuild = this.getLatestBuild();
        result = result * 59 + ($latestBuild == null ? 43 : ((Object)$latestBuild).hashCode());
        List<PromotionView> $promotions = this.getPromotions();
        result = result * 59 + ($promotions == null ? 43 : ((Object)$promotions).hashCode());
        return result;
    }

    public String toString() {
        return "BranchStatusView(branch=" + this.getBranch() + ", decorations=" + this.getDecorations() + ", latestBuild=" + this.getLatestBuild() + ", promotions=" + this.getPromotions() + ")";
    }
}

