/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.structure;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.NameDescriptionState;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.PromotionRunView;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationStamp;

public class Branch
implements ProjectEntity {
    private final ID id;
    private final String name;
    private final String description;
    private final boolean disabled;
    private final BranchType type;
    @JsonView(value={PromotionView.class, Branch.class, Build.class, PromotionLevel.class, ValidationStamp.class, PromotionRun.class, ValidationRun.class, PromotionRunView.class})
    @JsonProperty(value="project")
    private final Project project;
    private final Signature signature;

    public static Branch of(Project project, NameDescription nameDescription) {
        return Branch.of(project, nameDescription.asState());
    }

    public static Branch of(Project project, NameDescriptionState nameDescription) {
        return new Branch(ID.NONE, nameDescription.getName(), nameDescription.getDescription(), nameDescription.isDisabled(), BranchType.CLASSIC, project, Signature.none());
    }

    @Override
    public ProjectEntityType getProjectEntityType() {
        return ProjectEntityType.BRANCH;
    }

    @Override
    public String getEntityDisplayName() {
        return String.format("Branch %s/%s", this.project.getName(), this.name);
    }

    public Branch withId(ID id) {
        return new Branch(id, this.name, this.description, this.disabled, this.type, this.project, this.signature);
    }

    public static Form form() {
        return Form.create().with((Field)Form.defaultNameField().length(120)).description().with((Field)((YesNo)YesNo.of("disabled").label("Disabled")).help("Check if the branch must be disabled."));
    }

    public Form toForm() {
        return Branch.form().fill("name", this.name).fill("description", this.description).fill("disabled", this.disabled);
    }

    public Branch update(NameDescriptionState form) {
        return Branch.of(this.project, form).withId(this.id).withDisabled(form.isDisabled());
    }

    @Override
    public ID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public BranchType getType() {
        return this.type;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch other = (Branch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ID this$id = this.getId();
        ID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        BranchType this$type = this.getType();
        BranchType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Branch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        BranchType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    public String toString() {
        return "Branch(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", disabled=" + this.isDisabled() + ", type=" + (Object)((Object)this.getType()) + ", project=" + this.getProject() + ", signature=" + this.getSignature() + ")";
    }

    @ConstructorProperties(value={"id", "name", "description", "disabled", "type", "project", "signature"})
    public Branch(ID id, String name, String description, boolean disabled, BranchType type, Project project, Signature signature) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.disabled = disabled;
        this.type = type;
        this.project = project;
        this.signature = signature;
    }

    public Branch withDescription(String description) {
        return this.description == description ? this : new Branch(this.id, this.name, description, this.disabled, this.type, this.project, this.signature);
    }

    public Branch withDisabled(boolean disabled) {
        return this.disabled == disabled ? this : new Branch(this.id, this.name, this.description, disabled, this.type, this.project, this.signature);
    }

    public Branch withType(BranchType type) {
        return this.type == type ? this : new Branch(this.id, this.name, this.description, this.disabled, type, this.project, this.signature);
    }

    public Branch withSignature(Signature signature) {
        return this.signature == signature ? this : new Branch(this.id, this.name, this.description, this.disabled, this.type, this.project, signature);
    }
}

