/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.settings;

import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.settings.CachedSettingsService;
import net.nemerosa.ontrack.model.settings.SettingsManager;

public abstract class AbstractSettingsManager<T>
implements SettingsManager<T> {
    private final Class<T> settingsClass;
    private final CachedSettingsService cachedSettingsService;
    private final SecurityService securityService;

    protected AbstractSettingsManager(Class<T> settingsClass, CachedSettingsService cachedSettingsService, SecurityService securityService) {
        this.settingsClass = settingsClass;
        this.cachedSettingsService = cachedSettingsService;
        this.securityService = securityService;
    }

    @Override
    public final T getSettings() {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        return this.cachedSettingsService.getCachedSettings(this.settingsClass);
    }

    @Override
    public final Form getSettingsForm() {
        return this.getSettingsForm(this.cachedSettingsService.getCachedSettings(this.settingsClass));
    }

    @Override
    public final void saveSettings(T settings) {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        this.cachedSettingsService.invalidate(this.settingsClass);
        this.doSaveSettings(settings);
    }

    protected abstract void doSaveSettings(T var1);

    protected abstract Form getSettingsForm(T var1);

    @Override
    public final Class<T> getSettingsClass() {
        return this.settingsClass;
    }
}

