/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.model.security;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.nemerosa.ontrack.model.security.Account;
import net.nemerosa.ontrack.model.security.GlobalFunction;
import net.nemerosa.ontrack.model.security.ProjectFunction;
import net.nemerosa.ontrack.model.settings.SecuritySettings;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Signature;

public interface SecurityService {
    public SecuritySettings getSecuritySettings();

    public void checkGlobalFunction(Class<? extends GlobalFunction> var1);

    public boolean isGlobalFunctionGranted(Class<? extends GlobalFunction> var1);

    public void checkProjectFunction(int var1, Class<? extends ProjectFunction> var2);

    default public void checkProjectFunction(ProjectEntity entity, Class<? extends ProjectFunction> fn) {
        this.checkProjectFunction(entity.projectId(), fn);
    }

    public boolean isProjectFunctionGranted(int var1, Class<? extends ProjectFunction> var2);

    default public boolean isProjectFunctionGranted(ProjectEntity entity, Class<? extends ProjectFunction> fn) {
        return this.isProjectFunctionGranted(entity.projectId(), fn);
    }

    public Account getCurrentAccount();

    default public boolean isLogged() {
        return this.getCurrentAccount() != null;
    }

    default public Optional<Account> getAccount() {
        return Optional.ofNullable(this.getCurrentAccount());
    }

    public Signature getCurrentSignature();

    public <T> Supplier<T> runAsAdmin(Supplier<T> var1);

    public <T> T asAdmin(Supplier<T> var1);

    public void asAdmin(Runnable var1);

    public Runnable runAsAdmin(Runnable var1);

    public <T> Supplier<T> runner(Supplier<T> var1);

    public <T, R> Function<T, R> runner(Function<T, R> var1);
}

